/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class FuzzyLite {
    public static final String NAME = "jfuzzylite";
    public static final String VERSION = "6.0";
    public static final String LIBRARY = "jfuzzylite 6.0";
    public static final String LICENSE = "FuzzyLite License";
    public static final String AUTHOR = "Juan Rada-Vilela, Ph.D.";
    public static final String COMPANY = "FuzzyLite Limited";
    public static final String WEBSITE = "http://www.fuzzylite.com/";
    private static int decimals = 3;
    protected static double macheps = 1.0E-6;
    private static boolean debugging = false;
    private static final ThreadSafeDecimalFormat FORMATTER = new ThreadSafeDecimalFormat();
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    private static Logger logger = Logger.getLogger("com.fuzzylite");

    public static Logger logger() {
        return logger;
    }

    public static void setLogger(Logger logger) {
        FuzzyLite.logger = logger;
    }

    public static DecimalFormat getFormatter() {
        return (DecimalFormat)FORMATTER.get();
    }

    public static int getDecimals() {
        return decimals;
    }

    public static void setDecimals(int decimals) {
        FuzzyLite.decimals = decimals;
        StringBuilder pattern = new StringBuilder("0.".length() + decimals);
        pattern.append("0.");
        for (int i = 0; i < decimals; ++i) {
            pattern.append('0');
        }
        FORMATTER.set(new DecimalFormat(pattern.toString()));
    }

    public static double getMachEps() {
        return macheps;
    }

    public static void setMachEps(double macheps) {
        FuzzyLite.macheps = macheps;
    }

    public static void setLogging(boolean logging) {
        if (logging) {
            logger.setLevel(debugging ? Level.FINE : Level.INFO);
        } else {
            logger.setLevel(Level.OFF);
        }
    }

    public static boolean isLogging() {
        return logger.getLevel() != null && !logger.getLevel().equals(Level.OFF);
    }

    public static void setDebugging(boolean debugging) {
        FuzzyLite.debugging = debugging;
        if (FuzzyLite.isLogging()) {
            logger.setLevel(debugging ? Level.FINE : Level.INFO);
        }
    }

    public static boolean isDebugging() {
        return debugging;
    }

    static {
        String configurationFile = "/logging.properties";
        InputStream inputStream = FuzzyLite.class.getResourceAsStream("/logging.properties");
        try {
            LogManager.getLogManager().readConfiguration(inputStream);
        }
        catch (Exception ex) {
            System.out.println(String.format("WARNING: Could not load default %s file", "/logging.properties"));
            ex.printStackTrace(System.out);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static class ThreadSafeDecimalFormat
    extends ThreadLocal<DecimalFormat> {
        @Override
        protected DecimalFormat initialValue() {
            return new DecimalFormat("0.000");
        }
    }
}

