/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite;

import com.fuzzylite.FuzzyLite;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Op {
    public static double min(double a, double b) {
        if (Double.isNaN(a)) {
            return b;
        }
        if (Double.isNaN(b)) {
            return a;
        }
        return a < b ? a : b;
    }

    public static double max(double a, double b) {
        if (Double.isNaN(a)) {
            return b;
        }
        if (Double.isNaN(b)) {
            return a;
        }
        return a > b ? a : b;
    }

    public static double bound(double x, double min, double max) {
        if (x > max) {
            return max;
        }
        if (x < min) {
            return min;
        }
        return x;
    }

    public static boolean in(double x, double min, double max) {
        return Op.in(x, min, max, true, true);
    }

    public static boolean in(double x, double min, double max, boolean geq, boolean leq) {
        boolean left = geq ? Op.isGE(x, min) : Op.isGt(x, min);
        boolean right = leq ? Op.isLE(x, max) : Op.isLt(x, max);
        return left && right;
    }

    public static boolean isFinite(double x) {
        return !Double.isNaN(x) && !Double.isInfinite(x);
    }

    public static boolean isEq(double a, double b) {
        return a == b || Math.abs(a - b) < FuzzyLite.macheps || Double.isNaN(a) && Double.isNaN(b);
    }

    public static boolean isEq(double a, double b, double macheps) {
        return a == b || Math.abs(a - b) < macheps || Double.isNaN(a) && Double.isNaN(b);
    }

    public static boolean isNEq(double a, double b) {
        return !(a == b || Math.abs(a - b) < FuzzyLite.macheps || Double.isNaN(a) && Double.isNaN(b));
    }

    public static boolean isNEq(double a, double b, double macheps) {
        return !(a == b || Math.abs(a - b) < macheps || Double.isNaN(a) && Double.isNaN(b));
    }

    public static boolean isLt(double a, double b) {
        return a != b && !(Math.abs(a - b) < FuzzyLite.macheps) && (!Double.isNaN(a) || !Double.isNaN(b)) && a < b;
    }

    public static boolean isLt(double a, double b, double macheps) {
        return a != b && !(Math.abs(a - b) < macheps) && (!Double.isNaN(a) || !Double.isNaN(b)) && a < b;
    }

    public static boolean isLE(double a, double b) {
        return a == b || Math.abs(a - b) < FuzzyLite.macheps || Double.isNaN(a) && Double.isNaN(b) || a < b;
    }

    public static boolean isLE(double a, double b, double macheps) {
        return a == b || Math.abs(a - b) < macheps || Double.isNaN(a) && Double.isNaN(b) || a < b;
    }

    public static boolean isGt(double a, double b) {
        return a != b && !(Math.abs(a - b) < FuzzyLite.macheps) && (!Double.isNaN(a) || !Double.isNaN(b)) && a > b;
    }

    public static boolean isGt(double a, double b, double macheps) {
        return a != b && !(Math.abs(a - b) < macheps) && (!Double.isNaN(a) || !Double.isNaN(b)) && a > b;
    }

    public static boolean isGE(double a, double b) {
        return a == b || Math.abs(a - b) < FuzzyLite.macheps || Double.isNaN(a) && Double.isNaN(b) || a > b;
    }

    public static boolean isGE(double a, double b, double macheps) {
        return a == b || Math.abs(a - b) < macheps || Double.isNaN(a) && Double.isNaN(b) || a > b;
    }

    public static double eq(double a, double b) {
        return Op.isEq(a, b) ? 1.0 : 0.0;
    }

    public static double neq(double a, double b) {
        return Op.isNEq(a, b) ? 1.0 : 0.0;
    }

    public static double lt(double a, double b) {
        return Op.isLt(a, b) ? 1.0 : 0.0;
    }

    public static double le(double a, double b) {
        return Op.isLE(a, b) ? 1.0 : 0.0;
    }

    public static double gt(double a, double b) {
        return Op.isGt(a, b) ? 1.0 : 0.0;
    }

    public static double ge(double a, double b) {
        return Op.isGE(a, b) ? 1.0 : 0.0;
    }

    public static double add(double a, double b) {
        return a + b;
    }

    public static double subtract(double a, double b) {
        return a - b;
    }

    public static double multiply(double a, double b) {
        return a * b;
    }

    public static double divide(double a, double b) {
        return a / b;
    }

    public static double modulo(double a, double b) {
        return a % b;
    }

    public static double logicalAnd(double a, double b) {
        return Op.isEq(a, 1.0) && Op.isEq(b, 1.0) ? 1.0 : 0.0;
    }

    public static double logicalOr(double a, double b) {
        return Op.isEq(a, 1.0) || Op.isEq(b, 1.0) ? 1.0 : 0.0;
    }

    public static double logicalNot(double a) {
        return Op.isEq(a, 1.0) ? 0.0 : 1.0;
    }

    public static double negate(double a) {
        return -a;
    }

    public static double scale(double x, double fromMin, double fromMax, double toMin, double toMax) {
        return (toMax - toMin) / (fromMax - fromMin) * (x - fromMin) + toMin;
    }

    public static double scale(double x, double fromMin, double fromMax, double toMin, double toMax, boolean bounded) {
        double result = (toMax - toMin) / (fromMax - fromMin) * (x - fromMin) + toMin;
        return bounded ? Op.bound(x, toMin, toMax) : result;
    }

    public static double sum(double[] x) {
        double result = 0.0;
        for (double i : x) {
            result += i;
        }
        return result;
    }

    public static double mean(double[] x) {
        return Op.sum(x) / (double)x.length;
    }

    public static double variance(double[] x) {
        return Op.variance(x, Op.mean(x));
    }

    public static double variance(double[] x, double mean) {
        if (x.length == 0) {
            return Double.NaN;
        }
        if (x.length == 1) {
            return 0.0;
        }
        double result = 0.0;
        for (double i : x) {
            result += (i - mean) * (i - mean);
        }
        return result /= (double)(-1 + x.length);
    }

    public static double standardDeviation(double[] x) {
        return Op.standardDeviation(x, Op.mean(x));
    }

    public static double standardDeviation(double[] x, double mean) {
        if (x.length == 0) {
            return Double.NaN;
        }
        if (x.length == 1) {
            return 0.0;
        }
        return Math.sqrt(Op.variance(x, mean));
    }

    public static List<String> split(String string, String delimiter) {
        return Op.split(string, delimiter, true);
    }

    public static List<String> split(String string, String delimiter, boolean ignoreEmpty) {
        ArrayList<String> result = new ArrayList<String>();
        if (string.isEmpty() || delimiter.isEmpty()) {
            result.add(string);
            return result;
        }
        int position = 0;
        int next = 0;
        while (next >= 0) {
            next = string.indexOf(delimiter, position);
            String token = next < 0 ? string.substring(position) : string.substring(position, next);
            if (!token.isEmpty() || !ignoreEmpty) {
                result.add(token);
            }
            if (next < 0) continue;
            position = next + delimiter.length();
        }
        return result;
    }

    public static double toDouble(String x, double alternative) {
        try {
            return Op.toDouble(x);
        }
        catch (Exception ex) {
            return alternative;
        }
    }

    public static double toDouble(String x) throws NumberFormatException {
        if ("nan".equals(x)) {
            return Double.NaN;
        }
        if ("inf".equals(x)) {
            return Double.POSITIVE_INFINITY;
        }
        if ("-inf".equals(x)) {
            return Double.NEGATIVE_INFINITY;
        }
        return Double.parseDouble(x);
    }

    public static double[] toDoubles(String x) throws NumberFormatException {
        String[] tokens = x.split("\\s+");
        double[] result = new double[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            result[i] = Op.toDouble(tokens[i]);
        }
        return result;
    }

    public static double[] toDoubles(String x, double alternative) throws NumberFormatException {
        String[] tokens = x.split("\\s+");
        double[] result = new double[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            result[i] = Op.toDouble(tokens[i], alternative);
        }
        return result;
    }

    public static boolean isNumeric(String x) {
        try {
            Op.toDouble(x);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean increment(int[] array, int[] min, int[] max) {
        return Op.increment(array, array.length - 1, min, max);
    }

    public static boolean increment(int[] array, int position, int[] min, int[] max) {
        if (array.length == 0 || position < 0) {
            return false;
        }
        boolean incremented = true;
        if (array[position] < max[position]) {
            int n = position;
            array[n] = array[n] + 1;
        } else {
            incremented = position != 0;
            array[position] = min[position];
            if (--position >= 0) {
                incremented = Op.increment(array, position, min, max);
            }
        }
        return incremented;
    }

    public static <T extends Number> String str(T x) {
        return Op.str(x, FuzzyLite.getFormatter());
    }

    public static <T extends Number> String str(T x, DecimalFormat formatter) {
        if (Double.isNaN(x.doubleValue())) {
            return "nan";
        }
        if (Double.isInfinite(x.doubleValue())) {
            return Op.isLt(x.doubleValue(), 0.0) ? "-inf" : "inf";
        }
        return formatter.format(x);
    }

    public static <T> String join(Collection<T> x, String separator) {
        StringBuilder result = new StringBuilder();
        Iterator<T> it = x.iterator();
        while (it.hasNext()) {
            T item = it.next();
            if (item instanceof Number) {
                result.append(Op.str((Number)item));
            } else {
                result.append(item.toString());
            }
            if (!it.hasNext()) continue;
            result.append(separator);
        }
        return result.toString();
    }

    public static String join(long[] x, String separator) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < x.length; ++i) {
            result.append(Op.str(x[i]));
            if (i + 1 >= x.length) continue;
            result.append(separator);
        }
        return result.toString();
    }

    public static String join(int[] x, String separator) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < x.length; ++i) {
            result.append(Op.str(x[i]));
            if (i + 1 >= x.length) continue;
            result.append(separator);
        }
        return result.toString();
    }

    public static String join(double[] x, String separator) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < x.length; ++i) {
            result.append(Op.str(x[i]));
            if (i + 1 >= x.length) continue;
            result.append(separator);
        }
        return result.toString();
    }

    public static String join(float[] x, String separator) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < x.length; ++i) {
            result.append(Op.str(Float.valueOf(x[i])));
            if (i + 1 >= x.length) continue;
            result.append(separator);
        }
        return result.toString();
    }

    public static String join(String[] x, String separator) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < x.length; ++i) {
            result.append(x[i]);
            if (i + 1 >= x.length) continue;
            result.append(separator);
        }
        return result.toString();
    }

    public static <T> String join(String separator, T ... items) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < items.length; ++i) {
            T item = items[i];
            if (item instanceof Number) {
                result.append(Op.str((Number)item));
            } else {
                result.append(item.toString());
            }
            if (i + 1 >= items.length) continue;
            result.append(separator);
        }
        return result.toString();
    }

    public static String validName(String name) {
        if (name == null || name.trim().isEmpty()) {
            return "unnamed";
        }
        StringBuilder result = new StringBuilder();
        for (char c : name.toCharArray()) {
            if (c != '_' && c != '.' && !Character.isLetterOrDigit(c)) continue;
            result.append(c);
        }
        return result.toString();
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static class Pair<Y, Z> {
        private Y first;
        private Z second;

        public Pair() {
            this(null, null);
        }

        public Pair(Y first, Z second) {
            this.first = first;
            this.second = second;
        }

        public String toString() {
            return "{" + this.first + ":" + this.second + "}";
        }

        public Y getFirst() {
            return this.first;
        }

        public void setFirst(Y first) {
            this.first = first;
        }

        public Z getSecond() {
            return this.second;
        }

        public void setSecond(Z second) {
            this.second = second;
        }
    }

    public static interface Cloneable
    extends java.lang.Cloneable {
        public Object clone() throws CloneNotSupportedException;
    }
}

