/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.activation;

import com.fuzzylite.FuzzyLite;
import com.fuzzylite.Op;
import com.fuzzylite.activation.Activation;
import com.fuzzylite.norm.SNorm;
import com.fuzzylite.norm.TNorm;
import com.fuzzylite.rule.Rule;
import com.fuzzylite.rule.RuleBlock;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.logging.Level;

public class Highest
extends Activation {
    private int numberOfRules;

    public Highest() {
        this(1);
    }

    public Highest(int numberOfRules) {
        this.numberOfRules = numberOfRules;
    }

    @Override
    public String parameters() {
        return Op.str(this.getNumberOfRules());
    }

    @Override
    public void configure(String parameters) {
        if (parameters.isEmpty()) {
            return;
        }
        List<String> values = Op.split(parameters, " ", true);
        boolean required = true;
        if (values.size() < 1) {
            throw new RuntimeException(MessageFormat.format("[configuration error] activation {0} requires {1} parameters", this.getClass().getSimpleName(), 1));
        }
        this.setNumberOfRules(Integer.parseInt(values.get(0)));
    }

    @Override
    public void activate(RuleBlock ruleBlock) {
        if (FuzzyLite.isDebugging()) {
            FuzzyLite.logger().log(Level.FINE, "Activation: {0} {1}", new String[]{this.getClass().getName(), this.parameters()});
        }
        TNorm conjunction = ruleBlock.getConjunction();
        SNorm disjunction = ruleBlock.getDisjunction();
        TNorm implication = ruleBlock.getImplication();
        PriorityQueue<Rule> rulesToActivate = new PriorityQueue<Rule>(this.numberOfRules, new Descending());
        for (Rule rule : ruleBlock.getRules()) {
            double activationDegree;
            rule.deactivate();
            if (!rule.isLoaded() || !Op.isGt(activationDegree = rule.activateWith(conjunction, disjunction), 0.0)) continue;
            rulesToActivate.offer(rule);
        }
        int activated = 0;
        while (!rulesToActivate.isEmpty() && activated++ < this.numberOfRules) {
            rulesToActivate.poll().trigger(implication);
        }
    }

    public int getNumberOfRules() {
        return this.numberOfRules;
    }

    public void setNumberOfRules(int numberOfRules) {
        this.numberOfRules = numberOfRules;
    }

    @Override
    public Highest clone() throws CloneNotSupportedException {
        return (Highest)super.clone();
    }

    protected static class Descending
    implements Comparator<Rule> {
        protected Descending() {
        }

        @Override
        public int compare(Rule a, Rule b) {
            double result = Math.signum(b.getActivationDegree() - a.getActivationDegree());
            return Double.isNaN(result) ? -1 : (int)result;
        }
    }
}

