/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.activation;

import com.fuzzylite.FuzzyLite;
import com.fuzzylite.Op;
import com.fuzzylite.activation.Activation;
import com.fuzzylite.norm.SNorm;
import com.fuzzylite.norm.TNorm;
import com.fuzzylite.rule.Rule;
import com.fuzzylite.rule.RuleBlock;
import java.text.MessageFormat;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;

public class Last
extends Activation {
    private int numberOfRules;
    private double threshold;

    public Last() {
        this(1);
    }

    public Last(int numberOfRules) {
        this(numberOfRules, 0.0);
    }

    public Last(int numberOfRules, double threshold) {
        this.numberOfRules = numberOfRules;
        this.threshold = threshold;
    }

    @Override
    public String parameters() {
        return Op.str(this.getNumberOfRules()) + " " + Op.str(this.getThreshold());
    }

    @Override
    public void configure(String parameters) {
        if (parameters.isEmpty()) {
            return;
        }
        List<String> values = Op.split(parameters, " ", true);
        int required = 2;
        if (values.size() < 2) {
            throw new RuntimeException(MessageFormat.format("[configuration error] activation {0} requires {1} parameters", this.getClass().getSimpleName(), 2));
        }
        this.setNumberOfRules(Integer.parseInt(values.get(0)));
        this.setThreshold(Op.toDouble(values.get(1)));
    }

    @Override
    public void activate(RuleBlock ruleBlock) {
        if (FuzzyLite.isDebugging()) {
            FuzzyLite.logger().log(Level.FINE, "Activation: {0} {1}", new String[]{this.getClass().getName(), this.parameters()});
        }
        TNorm conjunction = ruleBlock.getConjunction();
        SNorm disjunction = ruleBlock.getDisjunction();
        TNorm implication = ruleBlock.getImplication();
        int activated = 0;
        int lastIndex = ruleBlock.getRules().size();
        ListIterator<Rule> rit = ruleBlock.getRules().listIterator(lastIndex);
        while (rit.hasPrevious()) {
            Rule rule = rit.previous();
            rule.deactivate();
            if (!rule.isLoaded()) continue;
            double activationDegree = rule.activateWith(conjunction, disjunction);
            if (activated >= this.numberOfRules || !Op.isGt(activationDegree, 0.0) || !Op.isGE(activationDegree, this.threshold)) continue;
            rule.trigger(implication);
            ++activated;
        }
    }

    public int getNumberOfRules() {
        return this.numberOfRules;
    }

    public void setNumberOfRules(int numberOfRules) {
        this.numberOfRules = numberOfRules;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    @Override
    public Last clone() throws CloneNotSupportedException {
        return (Last)super.clone();
    }
}

