/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.activation;

import com.fuzzylite.FuzzyLite;
import com.fuzzylite.activation.Activation;
import com.fuzzylite.norm.SNorm;
import com.fuzzylite.norm.TNorm;
import com.fuzzylite.rule.Rule;
import com.fuzzylite.rule.RuleBlock;
import java.util.ArrayList;
import java.util.logging.Level;

public class Proportional
extends Activation {
    @Override
    public String parameters() {
        return "";
    }

    @Override
    public void configure(String parameters) {
    }

    @Override
    public void activate(RuleBlock ruleBlock) {
        double activationDegree;
        if (FuzzyLite.isDebugging()) {
            FuzzyLite.logger().log(Level.FINE, "Activation: {0} {1}", new String[]{this.getClass().getName(), this.parameters()});
        }
        TNorm conjunction = ruleBlock.getConjunction();
        SNorm disjunction = ruleBlock.getDisjunction();
        TNorm implication = ruleBlock.getImplication();
        double sumActivationDegrees = 0.0;
        ArrayList<Rule> rulesToActivate = new ArrayList<Rule>(ruleBlock.getRules().size());
        for (Rule rule : ruleBlock.getRules()) {
            rule.deactivate();
            if (!rule.isLoaded()) continue;
            activationDegree = rule.activateWith(conjunction, disjunction);
            rulesToActivate.add(rule);
            sumActivationDegrees += activationDegree;
        }
        for (Rule rule : rulesToActivate) {
            activationDegree = rule.getActivationDegree() / sumActivationDegrees;
            rule.setActivationDegree(activationDegree);
            rule.trigger(implication);
        }
    }

    @Override
    public Proportional clone() throws CloneNotSupportedException {
        return (Proportional)super.clone();
    }
}

