/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.activation;

import com.fuzzylite.FuzzyLite;
import com.fuzzylite.Op;
import com.fuzzylite.activation.Activation;
import com.fuzzylite.norm.SNorm;
import com.fuzzylite.norm.TNorm;
import com.fuzzylite.rule.Rule;
import com.fuzzylite.rule.RuleBlock;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Level;

public class Threshold
extends Activation {
    private Comparison comparison;
    private double value;

    public Threshold() {
        this(Comparison.GreaterThanOrEqualTo, 0.0);
    }

    public Threshold(Comparison comparison, double threshold) {
        this.comparison = comparison;
        this.value = threshold;
    }

    public Comparison getComparison() {
        return this.comparison;
    }

    public void setComparison(Comparison comparison) {
        this.comparison = comparison;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public void setThreshold(Comparison comparison, double value) {
        this.setComparison(comparison);
        this.setValue(value);
    }

    @Override
    public String parameters() {
        return this.getComparison().operator() + " " + Op.str(this.getValue());
    }

    @Override
    public void configure(String parameters) {
        if (parameters.isEmpty()) {
            return;
        }
        List<String> values = Op.split(parameters, " ", true);
        int required = 2;
        if (values.size() < 2) {
            throw new RuntimeException(MessageFormat.format("[configuration error] activation {0} requires {1} parameters", this.getClass().getSimpleName(), 2));
        }
        this.setComparison(Comparison.fromOperator(values.get(0)));
        this.setValue(Op.toDouble(values.get(1)));
    }

    boolean activatesWith(double activationDegree) {
        if (Comparison.LessThan == this.comparison) {
            return Op.isLt(activationDegree, this.getValue());
        }
        if (Comparison.LessThanOrEqualTo == this.comparison) {
            return Op.isLE(activationDegree, this.getValue());
        }
        if (Comparison.EqualTo == this.comparison) {
            return Op.isEq(activationDegree, this.getValue());
        }
        if (Comparison.NotEqualTo == this.comparison) {
            return !Op.isEq(activationDegree, this.getValue());
        }
        if (Comparison.GreaterThanOrEqualTo == this.comparison) {
            return Op.isGE(activationDegree, this.getValue());
        }
        if (Comparison.GreaterThan == this.comparison) {
            return Op.isGt(activationDegree, this.getValue());
        }
        return false;
    }

    @Override
    public void activate(RuleBlock ruleBlock) {
        if (FuzzyLite.isDebugging()) {
            FuzzyLite.logger().log(Level.FINE, "Activation: {0} {1}", new String[]{this.getClass().getName(), this.parameters()});
        }
        TNorm conjunction = ruleBlock.getConjunction();
        SNorm disjunction = ruleBlock.getDisjunction();
        TNorm implication = ruleBlock.getImplication();
        for (Rule rule : ruleBlock.getRules()) {
            double activationDegree;
            rule.deactivate();
            if (!rule.isLoaded() || !this.activatesWith(activationDegree = rule.activateWith(conjunction, disjunction))) continue;
            rule.trigger(implication);
        }
    }

    @Override
    public Threshold clone() throws CloneNotSupportedException {
        return (Threshold)super.clone();
    }

    public static enum Comparison {
        LessThan,
        LessThanOrEqualTo,
        EqualTo,
        NotEqualTo,
        GreaterThanOrEqualTo,
        GreaterThan;

        static final String[] operators;

        public String operator() {
            return operators[this.ordinal()];
        }

        public static Comparison fromOperator(String operator) {
            for (int i = 0; i < operators.length; ++i) {
                if (!operators[i].equals(operator)) continue;
                return Comparison.values()[i];
            }
            throw new RuntimeException(MessageFormat.format("Comparison operator <{0}> not available", operator));
        }

        static {
            operators = new String[]{"<", "<=", "==", "!=", ">=", ">"};
        }
    }
}

