/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.defuzzifier;

import com.fuzzylite.Op;
import com.fuzzylite.defuzzifier.IntegralDefuzzifier;
import com.fuzzylite.term.Term;

public class Bisector
extends IntegralDefuzzifier {
    public Bisector() {
    }

    public Bisector(int resolution) {
        super(resolution);
    }

    @Override
    public double defuzzify(Term term, double minimum, double maximum) {
        if (!Op.isFinite(minimum + maximum)) {
            return Double.NaN;
        }
        double dx = (maximum - minimum) / (double)this.getResolution();
        int counter = this.getResolution();
        int left = 0;
        int right = 0;
        double leftArea = 0.0;
        double rightArea = 0.0;
        double xLeft = minimum;
        double xRight = maximum;
        while (counter-- > 0) {
            if (Op.isLE(leftArea, rightArea)) {
                xLeft = minimum + ((double)left + 0.5) * dx;
                leftArea += term.membership(xLeft);
                ++left;
                continue;
            }
            xRight = maximum - ((double)right + 0.5) * dx;
            rightArea += term.membership(xRight);
            ++right;
        }
        return (leftArea * xRight + rightArea * xLeft) / (leftArea + rightArea);
    }

    @Override
    public Bisector clone() throws CloneNotSupportedException {
        return (Bisector)super.clone();
    }
}

