/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.defuzzifier;

import com.fuzzylite.Op;
import com.fuzzylite.defuzzifier.IntegralDefuzzifier;
import com.fuzzylite.term.Term;

public class Centroid
extends IntegralDefuzzifier {
    public Centroid() {
    }

    public Centroid(int resolution) {
        super(resolution);
    }

    @Override
    public double defuzzify(Term term, double minimum, double maximum) {
        if (!Op.isFinite(minimum + maximum)) {
            return Double.NaN;
        }
        int resolution = this.getResolution();
        double dx = (maximum - minimum) / (double)resolution;
        double area = 0.0;
        double xcentroid = 0.0;
        for (int i = 0; i < resolution; ++i) {
            double x = minimum + ((double)i + 0.5) * dx;
            double y = term.membership(x);
            xcentroid += y * x;
            area += y;
        }
        return xcentroid / area;
    }

    @Override
    public Centroid clone() throws CloneNotSupportedException {
        return (Centroid)super.clone();
    }
}

