/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.defuzzifier;

import com.fuzzylite.Op;
import com.fuzzylite.defuzzifier.IntegralDefuzzifier;
import com.fuzzylite.term.Term;

public class LargestOfMaximum
extends IntegralDefuzzifier {
    public LargestOfMaximum() {
    }

    public LargestOfMaximum(int resolution) {
        super(resolution);
    }

    @Override
    public double defuzzify(Term term, double minimum, double maximum) {
        if (!Op.isFinite(minimum + maximum)) {
            return Double.NaN;
        }
        int resolution = this.getResolution();
        double dx = (maximum - minimum) / (double)resolution;
        double ymax = -1.0;
        double xlargest = maximum;
        for (int i = 0; i < resolution; ++i) {
            double x = minimum + ((double)i + 0.5) * dx;
            double y = term.membership(x);
            if (!Op.isGE(y, ymax)) continue;
            ymax = y;
            xlargest = x;
        }
        return xlargest;
    }

    @Override
    public LargestOfMaximum clone() throws CloneNotSupportedException {
        return (LargestOfMaximum)super.clone();
    }
}

