/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.defuzzifier;

import com.fuzzylite.Op;
import com.fuzzylite.defuzzifier.IntegralDefuzzifier;
import com.fuzzylite.term.Term;

public class MeanOfMaximum
extends IntegralDefuzzifier {
    public MeanOfMaximum() {
    }

    public MeanOfMaximum(int resolution) {
        super(resolution);
    }

    @Override
    public double defuzzify(Term term, double minimum, double maximum) {
        if (!Op.isFinite(minimum + maximum)) {
            return Double.NaN;
        }
        int resolution = this.getResolution();
        double dx = (maximum - minimum) / (double)resolution;
        double ymax = -1.0;
        double xsmallest = minimum;
        double xlargest = maximum;
        boolean samePlateau = false;
        for (int i = 0; i < resolution; ++i) {
            double x = minimum + ((double)i + 0.5) * dx;
            double y = term.membership(x);
            if (Op.isGt(y, ymax)) {
                ymax = y;
                xsmallest = x;
                xlargest = x;
                samePlateau = true;
                continue;
            }
            if (samePlateau && Op.isEq(y, ymax)) {
                xlargest = x;
                continue;
            }
            if (!Op.isLt(y, ymax)) continue;
            samePlateau = false;
        }
        return (xlargest + xsmallest) / 2.0;
    }

    @Override
    public MeanOfMaximum clone() throws CloneNotSupportedException {
        return (MeanOfMaximum)super.clone();
    }
}

