/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.defuzzifier;

import com.fuzzylite.Op;
import com.fuzzylite.defuzzifier.IntegralDefuzzifier;
import com.fuzzylite.term.Term;

public class SmallestOfMaximum
extends IntegralDefuzzifier {
    public SmallestOfMaximum() {
    }

    public SmallestOfMaximum(int resolution) {
        super(resolution);
    }

    @Override
    public double defuzzify(Term term, double minimum, double maximum) {
        if (!Op.isFinite(minimum + maximum)) {
            return Double.NaN;
        }
        int resolution = this.getResolution();
        double dx = (maximum - minimum) / (double)resolution;
        double ymax = -1.0;
        double xsmallest = minimum;
        for (int i = 0; i < resolution; ++i) {
            double x = minimum + ((double)i + 0.5) * dx;
            double y = term.membership(x);
            if (!Op.isGt(y, ymax)) continue;
            xsmallest = x;
            ymax = y;
        }
        return xsmallest;
    }

    @Override
    public SmallestOfMaximum clone() throws CloneNotSupportedException {
        return (SmallestOfMaximum)super.clone();
    }
}

