/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.defuzzifier;

import com.fuzzylite.defuzzifier.WeightedDefuzzifier;
import com.fuzzylite.term.Activated;
import com.fuzzylite.term.Aggregated;
import com.fuzzylite.term.Term;

public class WeightedAverage
extends WeightedDefuzzifier {
    public WeightedAverage() {
        super(WeightedDefuzzifier.Type.Automatic);
    }

    public WeightedAverage(WeightedDefuzzifier.Type type) {
        super(type);
    }

    public WeightedAverage(String type) {
        super(type);
    }

    @Override
    public double defuzzify(Term term, double minimum, double maximum) {
        Aggregated fuzzyOutput = (Aggregated)term;
        if (fuzzyOutput.getTerms().isEmpty()) {
            return Double.NaN;
        }
        minimum = fuzzyOutput.getMinimum();
        maximum = fuzzyOutput.getMaximum();
        WeightedDefuzzifier.Type type = this.getType();
        if (type == WeightedDefuzzifier.Type.Automatic) {
            type = this.inferType(fuzzyOutput.getTerms().get(0));
        }
        double sum = 0.0;
        double weights = 0.0;
        if (type == WeightedDefuzzifier.Type.TakagiSugeno) {
            for (Activated activated : fuzzyOutput.getTerms()) {
                double w = activated.getDegree();
                double z = activated.getTerm().membership(w);
                sum += w * z;
                weights += w;
            }
        } else {
            for (Activated activated : fuzzyOutput.getTerms()) {
                double w = activated.getDegree();
                double z = activated.getTerm().tsukamoto(w, minimum, maximum);
                sum += w * z;
                weights += w;
            }
        }
        return sum / weights;
    }

    @Override
    public WeightedAverage clone() throws CloneNotSupportedException {
        return (WeightedAverage)super.clone();
    }
}

