/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.defuzzifier;

import com.fuzzylite.defuzzifier.WeightedDefuzzifier;
import com.fuzzylite.norm.SNorm;
import com.fuzzylite.norm.TNorm;
import com.fuzzylite.term.Activated;
import com.fuzzylite.term.Aggregated;
import com.fuzzylite.term.Term;

public class WeightedAverageCustom
extends WeightedDefuzzifier {
    public WeightedAverageCustom() {
        super(WeightedDefuzzifier.Type.Automatic);
    }

    public WeightedAverageCustom(WeightedDefuzzifier.Type type) {
        super(type);
    }

    public WeightedAverageCustom(String type) {
        super(type);
    }

    @Override
    public double defuzzify(Term term, double minimum, double maximum) {
        Aggregated fuzzyOutput = (Aggregated)term;
        if (fuzzyOutput.getTerms().isEmpty()) {
            return Double.NaN;
        }
        minimum = fuzzyOutput.getMinimum();
        maximum = fuzzyOutput.getMaximum();
        WeightedDefuzzifier.Type type = this.getType();
        if (type == WeightedDefuzzifier.Type.Automatic) {
            type = this.inferType(fuzzyOutput.getTerms().get(0));
        }
        SNorm aggregation = fuzzyOutput.getAggregation();
        TNorm implication = null;
        double sum = 0.0;
        double weights = 0.0;
        if (type == WeightedDefuzzifier.Type.TakagiSugeno) {
            for (Activated activated : fuzzyOutput.getTerms()) {
                double wz;
                double w = activated.getDegree();
                double z = activated.getTerm().membership(w);
                implication = activated.getImplication();
                double d = wz = implication != null ? implication.compute(w, z) : w * z;
                if (aggregation != null) {
                    sum = aggregation.compute(sum, wz);
                    weights = aggregation.compute(weights, w);
                    continue;
                }
                sum += wz;
                weights += w;
            }
        } else {
            for (Activated activated : fuzzyOutput.getTerms()) {
                double w = activated.getDegree();
                double z = activated.getTerm().tsukamoto(w, minimum, maximum);
                sum += w * z;
                weights += w;
            }
        }
        return sum / weights;
    }

    @Override
    public WeightedAverageCustom clone() throws CloneNotSupportedException {
        return (WeightedAverageCustom)super.clone();
    }
}

