/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.factory;

import com.fuzzylite.Op;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CloningFactory<T extends Op.Cloneable>
implements Op.Cloneable {
    private Map<String, T> objects = new HashMap<String, T>();

    public void registerObject(String key, T object) {
        this.objects.put(key, object);
    }

    public void deregisterObject(String key) {
        if (this.objects.containsKey(key)) {
            this.objects.remove(key);
        }
    }

    public boolean hasObject(String key) {
        return this.objects.containsKey(key);
    }

    public T getObject(String key) {
        if (this.objects.containsKey(key)) {
            return (T)((Op.Cloneable)this.objects.get(key));
        }
        return null;
    }

    public T cloneObject(String key) {
        if (this.objects.containsKey(key)) {
            Op.Cloneable object = (Op.Cloneable)this.objects.get(key);
            if (object != null) {
                try {
                    return (T)((Op.Cloneable)object.clone());
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            return null;
        }
        throw new RuntimeException("[cloning error] object by name <" + key + "> not registered in " + this.getClass().getSimpleName());
    }

    public Set<String> available() {
        return new HashSet<String>(this.objects.keySet());
    }

    public Map<String, T> getObjects() {
        return this.objects;
    }

    public void setObjects(Map<String, T> objects) {
        this.objects = objects;
    }

    @Override
    public CloningFactory<T> clone() throws CloneNotSupportedException {
        CloningFactory result = (CloningFactory)super.clone();
        result.objects = new HashMap<String, T>(this.objects);
        return result;
    }
}

