/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.factory;

import com.fuzzylite.Op;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ConstructionFactory<T>
implements Op.Cloneable {
    private Map<String, Class<? extends T>> constructors = new HashMap<String, Class<? extends T>>();

    public void register(Class<? extends T> clazz) {
        this.register(clazz.getSimpleName(), clazz);
    }

    public void register(String simpleName, Class<? extends T> clazz) {
        this.constructors.put(simpleName, clazz);
    }

    public void deregister(String simpleName) {
        this.constructors.remove(simpleName);
    }

    public boolean hasConstructor(String simpleName) {
        return this.constructors.containsKey(simpleName);
    }

    public Class<? extends T> getConstructor(String simpleName) {
        return this.constructors.get(simpleName);
    }

    public Set<String> available() {
        return new HashSet<String>(this.constructors.keySet());
    }

    public T constructObject(String simpleName) {
        if (simpleName == null) {
            return null;
        }
        if (this.constructors.containsKey(simpleName)) {
            try {
                Class<T> clazz = this.constructors.get(simpleName);
                if (clazz != null) {
                    return clazz.newInstance();
                }
                return null;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        throw new RuntimeException("[construction error] constructor <" + simpleName + "> not registered in " + this.getClass().getSimpleName());
    }

    public Map<String, Class<? extends T>> getConstructors() {
        return this.constructors;
    }

    public void setConstructors(Map<String, Class<? extends T>> constructors) {
        this.constructors = constructors;
    }

    @Override
    public ConstructionFactory<T> clone() throws CloneNotSupportedException {
        ConstructionFactory result = (ConstructionFactory)super.clone();
        result.constructors = new HashMap<String, Class<T>>(this.constructors);
        return result;
    }
}

