/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.factory;

import com.fuzzylite.defuzzifier.Bisector;
import com.fuzzylite.defuzzifier.Centroid;
import com.fuzzylite.defuzzifier.Defuzzifier;
import com.fuzzylite.defuzzifier.IntegralDefuzzifier;
import com.fuzzylite.defuzzifier.LargestOfMaximum;
import com.fuzzylite.defuzzifier.MeanOfMaximum;
import com.fuzzylite.defuzzifier.SmallestOfMaximum;
import com.fuzzylite.defuzzifier.WeightedAverage;
import com.fuzzylite.defuzzifier.WeightedDefuzzifier;
import com.fuzzylite.defuzzifier.WeightedSum;
import com.fuzzylite.factory.ConstructionFactory;

public class DefuzzifierFactory
extends ConstructionFactory<Defuzzifier> {
    public DefuzzifierFactory() {
        this.register(Bisector.class);
        this.register(Centroid.class);
        this.register(LargestOfMaximum.class);
        this.register(MeanOfMaximum.class);
        this.register(SmallestOfMaximum.class);
        this.register(WeightedAverage.class);
        this.register(WeightedSum.class);
    }

    public Defuzzifier constructDefuzzifier(String key, int resolution, WeightedDefuzzifier.Type type) {
        Defuzzifier result = (Defuzzifier)this.constructObject(key);
        if (result instanceof IntegralDefuzzifier) {
            ((IntegralDefuzzifier)result).setResolution(resolution);
        } else if (result instanceof WeightedDefuzzifier) {
            ((WeightedDefuzzifier)result).setType(type);
        }
        return result;
    }

    public Defuzzifier constructDefuzzifier(String key, int resolution) {
        Defuzzifier result = (Defuzzifier)this.constructObject(key);
        if (result instanceof IntegralDefuzzifier) {
            ((IntegralDefuzzifier)result).setResolution(resolution);
        }
        return result;
    }

    public Defuzzifier constrDefuzzifier(String key, WeightedDefuzzifier.Type type) {
        Defuzzifier result = (Defuzzifier)this.constructObject(key);
        if (result instanceof WeightedDefuzzifier) {
            ((WeightedDefuzzifier)result).setType(type);
        }
        return result;
    }

    @Override
    public DefuzzifierFactory clone() throws CloneNotSupportedException {
        return (DefuzzifierFactory)super.clone();
    }
}

