/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.factory;

import com.fuzzylite.factory.ActivationFactory;
import com.fuzzylite.factory.DefuzzifierFactory;
import com.fuzzylite.factory.FunctionFactory;
import com.fuzzylite.factory.HedgeFactory;
import com.fuzzylite.factory.SNormFactory;
import com.fuzzylite.factory.TNormFactory;
import com.fuzzylite.factory.TermFactory;

public class FactoryManager {
    protected static final ThreadSafeFactoryManager INSTANCE = new ThreadSafeFactoryManager();
    private TNormFactory tnorm;
    private SNormFactory snorm;
    private ActivationFactory activation;
    private DefuzzifierFactory defuzzifier;
    private TermFactory term;
    private HedgeFactory hedge;
    private FunctionFactory function;

    public static FactoryManager instance() {
        return (FactoryManager)INSTANCE.get();
    }

    public FactoryManager() {
        this(new TNormFactory(), new SNormFactory(), new ActivationFactory(), new DefuzzifierFactory(), new TermFactory(), new HedgeFactory(), new FunctionFactory());
    }

    public FactoryManager(TNormFactory tnorm, SNormFactory snorm, ActivationFactory activation, DefuzzifierFactory defuzzifier, TermFactory term, HedgeFactory hedge, FunctionFactory function) {
        this.tnorm = tnorm;
        this.snorm = snorm;
        this.activation = activation;
        this.defuzzifier = defuzzifier;
        this.term = term;
        this.hedge = hedge;
        this.function = function;
    }

    public TNormFactory tnorm() {
        return this.tnorm;
    }

    public void setTNorm(TNormFactory tnorm) {
        this.tnorm = tnorm;
    }

    public SNormFactory snorm() {
        return this.snorm;
    }

    public void setSNorm(SNormFactory snorm) {
        this.snorm = snorm;
    }

    public ActivationFactory activation() {
        return this.activation;
    }

    public void setActivation(ActivationFactory activation) {
        this.activation = activation;
    }

    public DefuzzifierFactory defuzzifier() {
        return this.defuzzifier;
    }

    public void setDefuzzifier(DefuzzifierFactory defuzzifier) {
        this.defuzzifier = defuzzifier;
    }

    public TermFactory term() {
        return this.term;
    }

    public void setTerm(TermFactory term) {
        this.term = term;
    }

    public HedgeFactory hedge() {
        return this.hedge;
    }

    public void setHedge(HedgeFactory hedge) {
        this.hedge = hedge;
    }

    public FunctionFactory function() {
        return this.function;
    }

    public void setFunction(FunctionFactory function) {
        this.function = function;
    }

    public static class ThreadSafeFactoryManager
    extends ThreadLocal<FactoryManager> {
        @Override
        protected FactoryManager initialValue() {
            return new FactoryManager();
        }
    }
}

