/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.factory;

import com.fuzzylite.Op;
import com.fuzzylite.factory.CloningFactory;
import com.fuzzylite.term.Function;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class FunctionFactory
extends CloningFactory<Function.Element> {
    public FunctionFactory() {
        this.registerOperators();
        this.registerFunctions();
    }

    private void registerOperators() {
        int p = 100;
        try {
            this.registerObject("!", new Function.Element("!", "Logical NOT", Function.Element.Type.Operator, Op.class.getMethod("logicalNot", Double.TYPE), p, 1));
            this.registerObject("~", new Function.Element("~", "Negation", Function.Element.Type.Operator, Op.class.getMethod("negate", Double.TYPE), p, 1));
            this.registerObject("^", new Function.Element("^", "Power", Function.Element.Type.Operator, Math.class.getMethod("pow", Double.TYPE, Double.TYPE), p -= 10, 1));
            this.registerObject("*", new Function.Element("*", "Multiplication", Function.Element.Type.Operator, Op.class.getMethod("multiply", Double.TYPE, Double.TYPE), p -= 10));
            this.registerObject("/", new Function.Element("/", "Division", Function.Element.Type.Operator, Op.class.getMethod("divide", Double.TYPE, Double.TYPE), p));
            this.registerObject("%", new Function.Element("%", "Modulo", Function.Element.Type.Operator, Op.class.getMethod("modulo", Double.TYPE, Double.TYPE), p));
            this.registerObject("+", new Function.Element("+", "Addition", Function.Element.Type.Operator, Op.class.getMethod("add", Double.TYPE, Double.TYPE), p -= 10));
            this.registerObject("-", new Function.Element("-", "Subtraction", Function.Element.Type.Operator, Op.class.getMethod("subtract", Double.TYPE, Double.TYPE), p));
            this.registerObject("and", new Function.Element("and", "Logical AND", Function.Element.Type.Operator, Op.class.getMethod("logicalAnd", Double.TYPE, Double.TYPE), p -= 10));
            this.registerObject("or", new Function.Element("or", "Logical OR", Function.Element.Type.Operator, Op.class.getMethod("logicalOr", Double.TYPE, Double.TYPE), p -= 10));
        }
        catch (Exception ex) {
            throw new RuntimeException("[factory error] unable to register operator: " + ex.toString());
        }
    }

    private void registerFunctions() {
        try {
            this.registerObject("gt", new Function.Element("gt", "Greater than (>)", Function.Element.Type.Function, Op.class.getMethod("gt", Double.TYPE, Double.TYPE)));
            this.registerObject("ge", new Function.Element("ge", "Greater than or equal to (>=)", Function.Element.Type.Function, Op.class.getMethod("ge", Double.TYPE, Double.TYPE)));
            this.registerObject("eq", new Function.Element("eq", "Equal to (==)", Function.Element.Type.Function, Op.class.getMethod("eq", Double.TYPE, Double.TYPE)));
            this.registerObject("neq", new Function.Element("neq", "Not equal to (!=)", Function.Element.Type.Function, Op.class.getMethod("neq", Double.TYPE, Double.TYPE)));
            this.registerObject("le", new Function.Element("le", "Less than or equal to (<=)", Function.Element.Type.Function, Op.class.getMethod("le", Double.TYPE, Double.TYPE)));
            this.registerObject("lt", new Function.Element("lt", "Less than (<)", Function.Element.Type.Function, Op.class.getMethod("lt", Double.TYPE, Double.TYPE)));
            this.registerObject("acos", new Function.Element("acos", "Inverse cosine", Function.Element.Type.Function, Math.class.getMethod("acos", Double.TYPE)));
            this.registerObject("asin", new Function.Element("asin", "Inverse sine", Function.Element.Type.Function, Math.class.getMethod("asin", Double.TYPE)));
            this.registerObject("atan", new Function.Element("atan", "Inverse tangent", Function.Element.Type.Function, Math.class.getMethod("atan", Double.TYPE)));
            this.registerObject("ceil", new Function.Element("ceil", "Ceiling", Function.Element.Type.Function, Math.class.getMethod("ceil", Double.TYPE)));
            this.registerObject("cos", new Function.Element("cos", "Cosine", Function.Element.Type.Function, Math.class.getMethod("cos", Double.TYPE)));
            this.registerObject("cosh", new Function.Element("cosh", "Hyperbolic cosine", Function.Element.Type.Function, Math.class.getMethod("cosh", Double.TYPE)));
            this.registerObject("exp", new Function.Element("exp", "Exponential", Function.Element.Type.Function, Math.class.getMethod("exp", Double.TYPE)));
            this.registerObject("fabs", new Function.Element("fabs", "Absolute", Function.Element.Type.Function, Math.class.getMethod("abs", Double.TYPE)));
            this.registerObject("abs", new Function.Element("abs", "Absolute", Function.Element.Type.Function, Math.class.getMethod("abs", Double.TYPE)));
            this.registerObject("floor", new Function.Element("floor", "Floor", Function.Element.Type.Function, Math.class.getMethod("floor", Double.TYPE)));
            this.registerObject("log", new Function.Element("log", "Natural logarithm", Function.Element.Type.Function, Math.class.getMethod("log", Double.TYPE)));
            this.registerObject("log10", new Function.Element("log10", "Common logarithm", Function.Element.Type.Function, Math.class.getMethod("log10", Double.TYPE)));
            this.registerObject("sin", new Function.Element("sin", "Sine", Function.Element.Type.Function, Math.class.getMethod("sin", Double.TYPE)));
            this.registerObject("sinh", new Function.Element("sinh", "Hyperbolic sine", Function.Element.Type.Function, Math.class.getMethod("sinh", Double.TYPE)));
            this.registerObject("sqrt", new Function.Element("sqrt", "Square root", Function.Element.Type.Function, Math.class.getMethod("sqrt", Double.TYPE)));
            this.registerObject("tan", new Function.Element("tan", "Tangent", Function.Element.Type.Function, Math.class.getMethod("tan", Double.TYPE)));
            this.registerObject("tanh", new Function.Element("tanh", "Hyperbolic tangent", Function.Element.Type.Function, Math.class.getMethod("tanh", Double.TYPE)));
            this.registerObject("log1p", new Function.Element("log1p", "Natural logarithm plus one", Function.Element.Type.Function, Math.class.getMethod("log1p", Double.TYPE)));
            this.registerObject("atan", new Function.Element("log1p", "Natural logarithm plus one", Function.Element.Type.Function, Math.class.getMethod("atan", Double.TYPE)));
            this.registerObject("pow", new Function.Element("pow", "Power", Function.Element.Type.Function, Math.class.getMethod("pow", Double.TYPE, Double.TYPE)));
            this.registerObject("atan2", new Function.Element("atan2", "Inverse tangent (y/x)", Function.Element.Type.Function, Math.class.getMethod("atan2", Double.TYPE, Double.TYPE)));
            this.registerObject("fmod", new Function.Element("fmod", "Floating-point remainder", Function.Element.Type.Function, Op.class.getMethod("modulo", Double.TYPE, Double.TYPE)));
        }
        catch (Exception ex) {
            throw new RuntimeException("[factory error] unable to register function: " + ex.toString());
        }
    }

    public Set<String> availableOperators() {
        HashSet<String> operators = new HashSet<String>(this.getObjects().keySet());
        Iterator it = operators.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (((Function.Element)this.getObject(key)).isOperator()) continue;
            it.remove();
        }
        return operators;
    }

    public Set<String> availableFunctions() {
        HashSet<String> functions = new HashSet<String>(this.getObjects().keySet());
        Iterator it = functions.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (((Function.Element)this.getObject(key)).isFunction()) continue;
            it.remove();
        }
        return functions;
    }

    @Override
    public FunctionFactory clone() throws CloneNotSupportedException {
        return (FunctionFactory)super.clone();
    }
}

