/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.hedge;

import com.fuzzylite.hedge.Hedge;
import com.fuzzylite.term.Function;

public final class HedgeFunction
extends Hedge {
    private Function function = new Function();

    public HedgeFunction() {
        this("");
    }

    public HedgeFunction(String formula) {
        this.function.getVariables().put("x", Double.NaN);
        if (!formula.isEmpty()) {
            this.function.load(formula);
        }
    }

    public Function function() {
        return this.function;
    }

    public void setFormula(String formula) {
        this.function.load(formula);
    }

    public String getFormula() {
        return this.function.getFormula();
    }

    @Override
    public double hedge(double x) {
        return this.function.membership(x);
    }

    @Override
    public HedgeFunction clone() throws CloneNotSupportedException {
        HedgeFunction result = (HedgeFunction)super.clone();
        if (this.function != null) {
            result.function = this.function.clone();
        }
        return result;
    }
}

