/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.imex;

import com.fuzzylite.Engine;
import com.fuzzylite.Op;
import com.fuzzylite.defuzzifier.Bisector;
import com.fuzzylite.defuzzifier.Centroid;
import com.fuzzylite.defuzzifier.Defuzzifier;
import com.fuzzylite.defuzzifier.LargestOfMaximum;
import com.fuzzylite.defuzzifier.MeanOfMaximum;
import com.fuzzylite.defuzzifier.SmallestOfMaximum;
import com.fuzzylite.defuzzifier.WeightedAverage;
import com.fuzzylite.defuzzifier.WeightedSum;
import com.fuzzylite.imex.Exporter;
import com.fuzzylite.norm.Norm;
import com.fuzzylite.norm.s.AlgebraicSum;
import com.fuzzylite.norm.s.BoundedSum;
import com.fuzzylite.norm.s.DrasticSum;
import com.fuzzylite.norm.s.EinsteinSum;
import com.fuzzylite.norm.s.HamacherSum;
import com.fuzzylite.norm.s.Maximum;
import com.fuzzylite.norm.s.NilpotentMaximum;
import com.fuzzylite.norm.s.NormalizedSum;
import com.fuzzylite.norm.t.AlgebraicProduct;
import com.fuzzylite.norm.t.BoundedDifference;
import com.fuzzylite.norm.t.DrasticProduct;
import com.fuzzylite.norm.t.EinsteinProduct;
import com.fuzzylite.norm.t.HamacherProduct;
import com.fuzzylite.norm.t.Minimum;
import com.fuzzylite.norm.t.NilpotentMinimum;
import com.fuzzylite.rule.Rule;
import com.fuzzylite.rule.RuleBlock;
import com.fuzzylite.term.Constant;
import com.fuzzylite.term.Discrete;
import com.fuzzylite.term.Term;
import com.fuzzylite.variable.InputVariable;
import com.fuzzylite.variable.OutputVariable;
import java.util.Iterator;

public class FclExporter
extends Exporter {
    private String indent;

    public FclExporter() {
        this("  ");
    }

    public FclExporter(String indent) {
        this.indent = indent;
    }

    public String getIndent() {
        return this.indent;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    @Override
    public String toString(Engine engine) {
        StringBuilder result = new StringBuilder();
        result.append("//Code automatically generated with jfuzzylite 6.0.\n\n");
        result.append(String.format("FUNCTION_BLOCK %s\n", engine.getName()));
        result.append("\n");
        result.append("VAR_INPUT\n");
        for (InputVariable inputVariable : engine.getInputVariables()) {
            result.append(String.format(this.indent + "%s: REAL;\n", inputVariable.getName()));
        }
        result.append("END_VAR\n");
        result.append("\n");
        result.append("VAR_OUTPUT\n");
        for (OutputVariable outputVariable : engine.getOutputVariables()) {
            result.append(String.format(this.indent + "%s: REAL;\n", outputVariable.getName()));
        }
        result.append("END_VAR\n");
        result.append("\n");
        for (InputVariable inputVariable : engine.getInputVariables()) {
            result.append(this.toString(inputVariable)).append("\n");
        }
        for (OutputVariable outputVariable : engine.getOutputVariables()) {
            result.append(this.toString(outputVariable)).append("\n");
        }
        for (RuleBlock ruleBlock : engine.getRuleBlocks()) {
            result.append(this.toString(ruleBlock)).append("\n");
        }
        result.append("END_FUNCTION_BLOCK\n");
        return result.toString();
    }

    public String toString(InputVariable inputVariable) {
        StringBuilder result = new StringBuilder();
        result.append(String.format("FUZZIFY %s\n", inputVariable.getName()));
        result.append(String.format(this.indent + "RANGE := (%s .. %s);\n", Op.str(inputVariable.getMinimum()), Op.str(inputVariable.getMaximum())));
        for (Term term : inputVariable.getTerms()) {
            result.append(String.format(this.indent + "TERM %s := %s;\n", term.getName(), this.toString(term)));
        }
        result.append("END_FUZZIFY\n");
        return result.toString();
    }

    public String toString(OutputVariable outputVariable) {
        StringBuilder result = new StringBuilder();
        result.append(String.format("DEFUZZIFY %s\n", outputVariable.getName()));
        result.append(String.format(this.indent + "RANGE := (%s .. %s);\n", Op.str(outputVariable.getMinimum()), Op.str(outputVariable.getMaximum())));
        for (Term term : outputVariable.getTerms()) {
            result.append(String.format(this.indent + "TERM %s := %s;\n", term.getName(), this.toString(term)));
        }
        if (outputVariable.getDefuzzifier() != null) {
            result.append(String.format(this.indent + "METHOD : %s;\n", this.toString(outputVariable.getDefuzzifier())));
        }
        if (outputVariable.fuzzyOutput().getAggregation() != null) {
            result.append(String.format(this.indent + "ACCU : %s;\n", this.toString(outputVariable.fuzzyOutput().getAggregation())));
        }
        result.append(String.format(this.indent + "DEFAULT := %s", Op.str(outputVariable.getDefaultValue())));
        if (outputVariable.isLockPreviousValue()) {
            result.append(" | NC");
        }
        result.append(";\n");
        result.append("END_DEFUZZIFY\n");
        return result.toString();
    }

    public String toString(RuleBlock ruleBlock) {
        StringBuilder result = new StringBuilder();
        result.append(String.format("RULEBLOCK %s\n", ruleBlock.getName()));
        if (ruleBlock.getConjunction() != null) {
            result.append(String.format(this.indent + "AND : %s;\n", this.toString(ruleBlock.getConjunction())));
        }
        if (ruleBlock.getDisjunction() != null) {
            result.append(String.format(this.indent + "OR : %s;\n", this.toString(ruleBlock.getDisjunction())));
        }
        if (ruleBlock.getImplication() != null) {
            result.append(String.format(this.indent + "ACT : %s;\n", this.toString(ruleBlock.getImplication())));
        }
        int index = 1;
        for (Rule rule : ruleBlock.getRules()) {
            result.append(String.format(this.indent + "RULE %d : %s\n", index++, rule.getText()));
        }
        result.append("END_RULEBLOCK\n");
        return result.toString();
    }

    public String toString(Norm norm) {
        if (norm == null) {
            return "NONE";
        }
        if (norm instanceof Minimum) {
            return "MIN";
        }
        if (norm instanceof AlgebraicProduct) {
            return "PROD";
        }
        if (norm instanceof BoundedDifference) {
            return "BDIF";
        }
        if (norm instanceof DrasticProduct) {
            return "DPROD";
        }
        if (norm instanceof EinsteinProduct) {
            return "EPROD";
        }
        if (norm instanceof HamacherProduct) {
            return "HPROD";
        }
        if (norm instanceof NilpotentMinimum) {
            return "NMIN";
        }
        if (norm instanceof Maximum) {
            return "MAX";
        }
        if (norm instanceof AlgebraicSum) {
            return "ASUM";
        }
        if (norm instanceof NormalizedSum) {
            return "NSUM";
        }
        if (norm instanceof BoundedSum) {
            return "BSUM";
        }
        if (norm instanceof DrasticSum) {
            return "DSUM";
        }
        if (norm instanceof EinsteinSum) {
            return "ESUM";
        }
        if (norm instanceof HamacherSum) {
            return "HSUM";
        }
        if (norm instanceof NilpotentMaximum) {
            return "NMAX";
        }
        return norm.getClass().getSimpleName();
    }

    public String toString(Defuzzifier defuzzifier) {
        if (defuzzifier == null) {
            return "NONE";
        }
        if (defuzzifier instanceof Centroid) {
            return "COG";
        }
        if (defuzzifier instanceof Bisector) {
            return "COA";
        }
        if (defuzzifier instanceof SmallestOfMaximum) {
            return "LM";
        }
        if (defuzzifier instanceof LargestOfMaximum) {
            return "RM";
        }
        if (defuzzifier instanceof MeanOfMaximum) {
            return "MM";
        }
        if (defuzzifier instanceof WeightedAverage) {
            return "COGS";
        }
        if (defuzzifier instanceof WeightedSum) {
            return "COGSS";
        }
        return defuzzifier.getClass().getSimpleName();
    }

    public String toString(Term term) {
        if (term == null) {
            return "";
        }
        if (term instanceof Discrete) {
            StringBuilder result = new StringBuilder();
            Discrete discrete = (Discrete)term;
            Iterator<Discrete.Pair> it = discrete.iterator();
            while (it.hasNext()) {
                Discrete.Pair xy = it.next();
                result.append(String.format("(%s, %s)", Op.str(xy.getX()), Op.str(xy.getY())));
                if (!it.hasNext()) continue;
                result.append(" ");
            }
            return result.toString();
        }
        if (term instanceof Constant) {
            Constant constant = (Constant)term;
            return Op.str(constant.getValue());
        }
        return term.getClass().getSimpleName() + " " + term.parameters();
    }

    @Override
    public FclExporter clone() throws CloneNotSupportedException {
        return (FclExporter)super.clone();
    }
}

