/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.imex;

import com.fuzzylite.Engine;
import com.fuzzylite.Op;
import com.fuzzylite.activation.General;
import com.fuzzylite.defuzzifier.Bisector;
import com.fuzzylite.defuzzifier.Centroid;
import com.fuzzylite.defuzzifier.Defuzzifier;
import com.fuzzylite.defuzzifier.LargestOfMaximum;
import com.fuzzylite.defuzzifier.MeanOfMaximum;
import com.fuzzylite.defuzzifier.SmallestOfMaximum;
import com.fuzzylite.defuzzifier.WeightedAverage;
import com.fuzzylite.defuzzifier.WeightedSum;
import com.fuzzylite.factory.FactoryManager;
import com.fuzzylite.imex.Importer;
import com.fuzzylite.norm.SNorm;
import com.fuzzylite.norm.TNorm;
import com.fuzzylite.norm.s.AlgebraicSum;
import com.fuzzylite.norm.s.BoundedSum;
import com.fuzzylite.norm.s.DrasticSum;
import com.fuzzylite.norm.s.EinsteinSum;
import com.fuzzylite.norm.s.HamacherSum;
import com.fuzzylite.norm.s.Maximum;
import com.fuzzylite.norm.s.NilpotentMaximum;
import com.fuzzylite.norm.s.NormalizedSum;
import com.fuzzylite.norm.t.AlgebraicProduct;
import com.fuzzylite.norm.t.BoundedDifference;
import com.fuzzylite.norm.t.DrasticProduct;
import com.fuzzylite.norm.t.EinsteinProduct;
import com.fuzzylite.norm.t.HamacherProduct;
import com.fuzzylite.norm.t.Minimum;
import com.fuzzylite.norm.t.NilpotentMinimum;
import com.fuzzylite.rule.Rule;
import com.fuzzylite.rule.RuleBlock;
import com.fuzzylite.term.Constant;
import com.fuzzylite.term.Discrete;
import com.fuzzylite.term.Function;
import com.fuzzylite.term.Term;
import com.fuzzylite.variable.InputVariable;
import com.fuzzylite.variable.OutputVariable;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class FclImporter
extends Importer {
    @Override
    public Engine fromString(String fcl) {
        Engine engine = new Engine();
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("VAR_INPUT", "END_VAR");
        tags.put("VAR_OUTPUT", "END_VAR");
        tags.put("FUZZIFY", "END_FUZZIFY");
        tags.put("DEFUZZIFY", "END_DEFUZZIFY");
        tags.put("RULEBLOCK", "END_RULEBLOCK");
        String currentTag = "";
        String closingTag = "";
        StringBuilder block = new StringBuilder();
        BufferedReader fclReader = new BufferedReader(new StringReader(fcl));
        int lineNumber = 0;
        try {
            String line;
            while ((line = fclReader.readLine()) != null) {
                ++lineNumber;
                line = Op.split(line, "//", false).get(0);
                line = Op.split(line, "#", false).get(0);
                if ((line = line.trim().replaceAll(Pattern.quote(";"), "")).isEmpty() || line.charAt(0) == '%') continue;
                StringTokenizer tokenizer = new StringTokenizer(line);
                String firstToken = tokenizer.nextToken();
                if ("FUNCTION_BLOCK".equals(firstToken)) {
                    if (!tokenizer.hasMoreTokens()) continue;
                    StringBuilder name = new StringBuilder();
                    name.append(tokenizer.nextToken());
                    while (tokenizer.hasMoreTokens()) {
                        name.append(" ").append(tokenizer.nextToken());
                    }
                    engine.setName(name.toString());
                    continue;
                }
                if ("END_FUNCTION_BLOCK".equals(firstToken)) break;
                if (currentTag.isEmpty()) {
                    if (!tags.containsKey(firstToken)) {
                        throw new RuntimeException(String.format("[syntax error] unknown block definition <%s> in line <%d>: %s", firstToken, lineNumber, line));
                    }
                    currentTag = firstToken;
                    closingTag = (String)tags.get(firstToken);
                    block.setLength(0);
                    block.append(line).append("\n");
                    continue;
                }
                if (!currentTag.isEmpty()) {
                    if (firstToken.equals(closingTag)) {
                        this.processBlock(currentTag, block.toString(), engine);
                        currentTag = "";
                        closingTag = "";
                        continue;
                    }
                    if (tags.containsKey(firstToken)) {
                        throw new RuntimeException(String.format("[syntax error] expected <%s> before <%s> in line: %s", closingTag, firstToken, line));
                    }
                    block.append(line).append("\n");
                    continue;
                }
                if (currentTag.isEmpty()) continue;
                String error = "[syntax error] ";
                error = block.length() > 0 ? error + String.format("expected <%s> for block:\n%s", closingTag, block.toString()) : error + String.format("expected <%s>, but not found", closingTag);
                throw new RuntimeException(error);
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return engine;
    }

    protected void processBlock(String tag, String block, Engine engine) throws Exception {
        if ("VAR_INPUT".equals(tag) || "VAR_OUTPUT".equals(tag)) {
            this.processVar(tag, block, engine);
        } else if ("FUZZIFY".equals(tag)) {
            this.processFuzzify(block, engine);
        } else if ("DEFUZZIFY".equals(tag)) {
            this.processDefuzzify(block, engine);
        } else if ("RULEBLOCK".equals(tag)) {
            this.processRuleBlock(block, engine);
        } else {
            throw new RuntimeException(String.format("[syntax error] unexpected tag <%s> for block:\n%s", tag, block));
        }
    }

    protected void processVar(String tag, String block, Engine engine) throws Exception {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(block));
        reader.readLine();
        while ((line = reader.readLine()) != null) {
            List<String> token = Op.split(line, ":");
            if (token.size() != 2) {
                throw new RuntimeException(String.format("[syntax error] expected property of type (key : value) in line: %s", line));
            }
            String name = Op.validName(token.get(0));
            if ("VAR_INPUT".equals(tag)) {
                engine.addInputVariable(new InputVariable(name));
                continue;
            }
            if ("VAR_OUTPUT".equals(tag)) {
                engine.addOutputVariable(new OutputVariable(name));
                continue;
            }
            throw new RuntimeException(String.format("[syntax error] unexpected tag <%s> in line: %s", tag, line));
        }
    }

    protected void processFuzzify(String block, Engine engine) throws Exception {
        BufferedReader reader = new BufferedReader(new StringReader(block));
        String line = reader.readLine();
        if (line == null) {
            return;
        }
        int index = line.indexOf(32);
        if (index < 0) {
            throw new RuntimeException("[syntax error] expected name of input variable in line: " + line);
        }
        String name = Op.validName(line.substring(index + 1));
        if (!engine.hasInputVariable(name)) {
            throw new RuntimeException(String.format("[syntax error] engine does not contain input variable <%s> from line: %s", name, line));
        }
        InputVariable inputVariable = engine.getInputVariable(name);
        while ((line = reader.readLine()) != null) {
            StringTokenizer tokenizer = new StringTokenizer(line);
            String firstToken = tokenizer.nextToken();
            if ("RANGE".equals(firstToken)) {
                Op.Pair<Double, Double> range = this.parseRange(line);
                inputVariable.setRange(range.getFirst(), range.getSecond());
                continue;
            }
            if ("ENABLED".equals(firstToken)) {
                inputVariable.setEnabled(this.parseEnabled(line));
                continue;
            }
            if ("TERM".equals(firstToken)) {
                inputVariable.addTerm(this.parseTerm(line, engine));
                continue;
            }
            throw new RuntimeException(String.format("[syntax error] token <%s> not recognized", firstToken));
        }
    }

    protected void processDefuzzify(String block, Engine engine) throws Exception {
        BufferedReader reader = new BufferedReader(new StringReader(block));
        String line = reader.readLine();
        if (line == null) {
            return;
        }
        int index = line.indexOf(32);
        if (index < 0) {
            throw new RuntimeException("[syntax error] expected name of output variable in line: " + line);
        }
        String name = Op.validName(line.substring(index + 1));
        if (!engine.hasOutputVariable(name)) {
            throw new RuntimeException(String.format("[syntax error] engine does not contain output variable <%s> from line: %s", name, line));
        }
        OutputVariable outputVariable = engine.getOutputVariable(name);
        while ((line = reader.readLine()) != null) {
            StringTokenizer tokenizer = new StringTokenizer(line);
            String firstToken = tokenizer.nextToken();
            if ("TERM".equals(firstToken)) {
                outputVariable.addTerm(this.parseTerm(line, engine));
                continue;
            }
            if ("METHOD".equals(firstToken)) {
                outputVariable.setDefuzzifier(this.parseDefuzzifier(line));
                continue;
            }
            if ("ACCU".equals(firstToken)) {
                outputVariable.fuzzyOutput().setAggregation(this.parseSNorm(line));
                continue;
            }
            if ("DEFAULT".equals(firstToken)) {
                Op.Pair<Double, Boolean> defaultAndLock = this.parseDefaultValue(line);
                outputVariable.setDefaultValue(defaultAndLock.getFirst());
                outputVariable.setLockPreviousValue(defaultAndLock.getSecond() != false || outputVariable.isLockPreviousValue());
                continue;
            }
            if ("RANGE".equals(firstToken)) {
                Op.Pair<Double, Double> range = this.parseRange(line);
                outputVariable.setRange(range.getFirst(), range.getSecond());
                continue;
            }
            if ("LOCK".equals(firstToken)) {
                Op.Pair<Boolean, Boolean> outputRange = this.parseLocks(line);
                outputVariable.setLockPreviousValue(outputRange.getFirst());
                outputVariable.setLockValueInRange(outputRange.getSecond());
                continue;
            }
            if ("ENABLED".equals(firstToken)) {
                outputVariable.setEnabled(this.parseEnabled(line));
                continue;
            }
            throw new RuntimeException(String.format("[syntax error] unexpected token <%s>", firstToken));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRuleBlock(String block, Engine engine) throws Exception {
        BufferedReader reader = new BufferedReader(new StringReader(block));
        String line = reader.readLine();
        if (line == null) {
            return;
        }
        String name = "";
        int index = line.indexOf(32);
        if (index >= 0) {
            name = line.substring(index + 1);
        }
        RuleBlock ruleBlock = new RuleBlock(name);
        ruleBlock.setActivation(new General());
        engine.addRuleBlock(ruleBlock);
        while ((line = reader.readLine()) != null) {
            String firstToken = line.substring(0, line.indexOf(32));
            if ("AND".equals(firstToken)) {
                ruleBlock.setConjunction(this.parseTNorm(line));
                continue;
            }
            if ("OR".equals(firstToken)) {
                ruleBlock.setDisjunction(this.parseSNorm(line));
                continue;
            }
            if ("ACT".equals(firstToken)) {
                ruleBlock.setImplication(this.parseTNorm(line));
                continue;
            }
            if ("ENABLED".equals(firstToken)) {
                ruleBlock.setEnabled(this.parseEnabled(line));
                continue;
            }
            if ("RULE".equals(firstToken)) {
                int ruleStart = line.indexOf(58);
                if (ruleStart < 0) {
                    ruleStart = "RULE".length();
                }
                String ruleText = line.substring(ruleStart + 1).trim();
                Rule rule = new Rule(ruleText);
                try {
                    rule.load(engine);
                    continue;
                }
                finally {
                    ruleBlock.addRule(rule);
                    continue;
                }
            }
            throw new RuntimeException(String.format("[syntax error] keyword <%s> not recognized in line %s", firstToken, line));
        }
    }

    protected TNorm parseTNorm(String line) {
        String name;
        List<String> token = Op.split(line, ":");
        if (token.size() != 2) {
            throw new RuntimeException("[syntax error] expected property of type (key : value) in line: " + line);
        }
        String className = name = token.get(1).trim();
        if ("NONE".equals(name)) {
            className = "";
        } else if ("MIN".equals(name)) {
            className = Minimum.class.getSimpleName();
        } else if ("PROD".equals(name)) {
            className = AlgebraicProduct.class.getSimpleName();
        } else if ("BDIF".equals(name)) {
            className = BoundedDifference.class.getSimpleName();
        } else if ("DPROD".equals(name)) {
            className = DrasticProduct.class.getSimpleName();
        } else if ("EPROD".equals(name)) {
            className = EinsteinProduct.class.getSimpleName();
        } else if ("HPROD".equals(name)) {
            className = HamacherProduct.class.getSimpleName();
        } else if ("NMIN".equals(name)) {
            className = NilpotentMinimum.class.getSimpleName();
        }
        return (TNorm)FactoryManager.instance().tnorm().constructObject(className);
    }

    protected SNorm parseSNorm(String line) {
        String name;
        List<String> token = Op.split(line, ":");
        if (token.size() != 2) {
            throw new RuntimeException("[syntax error] expected property of type (key : value) in line: " + line);
        }
        String className = name = token.get(1).trim();
        if ("NONE".equals(name)) {
            className = "";
        } else if ("MAX".equals(name)) {
            className = Maximum.class.getSimpleName();
        } else if ("ASUM".equals(name)) {
            className = AlgebraicSum.class.getSimpleName();
        } else if ("BSUM".equals(name)) {
            className = BoundedSum.class.getSimpleName();
        } else if ("NSUM".equals(name)) {
            className = NormalizedSum.class.getSimpleName();
        } else if ("DSUM".equals(name)) {
            className = DrasticSum.class.getSimpleName();
        } else if ("ESUM".equals(name)) {
            className = EinsteinSum.class.getSimpleName();
        } else if ("HSUM".equals(name)) {
            className = HamacherSum.class.getSimpleName();
        } else if ("NMAX".equals(name)) {
            className = NilpotentMaximum.class.getSimpleName();
        }
        return (SNorm)FactoryManager.instance().snorm().constructObject(className);
    }

    protected Term parseTerm(String line, Engine engine) {
        StringBuilder spacedLine = new StringBuilder();
        for (char c : line.toCharArray()) {
            if (c == '(' || c == ')' || c == ',') {
                spacedLine.append(" ").append(c).append(" ");
                continue;
            }
            if (c == ':') {
                spacedLine.append(" :");
                continue;
            }
            if (c == '=') {
                spacedLine.append("= ");
                continue;
            }
            spacedLine.append(c);
        }
        boolean S_KWTERM = true;
        int S_NAME = 2;
        int S_ASSIGN = 3;
        int S_TERM_CLASS = 4;
        int S_PARAMETERS = 5;
        int state = 1;
        StringTokenizer tokenizer = new StringTokenizer(spacedLine.toString());
        String name = "";
        String termClass = "";
        ArrayList<String> parameters = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (state == 1 && "TERM".equals(token)) {
                state = 2;
                continue;
            }
            if (state == 2) {
                name = token;
                state = 3;
                continue;
            }
            if (state == 3 && ":=".equals(token)) {
                state = 4;
                continue;
            }
            if (state == 4) {
                if (Op.isNumeric(token)) {
                    termClass = Constant.class.getSimpleName();
                    parameters.add(token);
                } else {
                    termClass = "(".equals(token) ? Discrete.class.getSimpleName() : token;
                }
                state = 5;
                continue;
            }
            if (state != 5 || !Function.class.getSimpleName().equals(termClass) && ("(".equals(token) || ")".equals(token) || ",".equals(token))) continue;
            if (";".equals(token)) break;
            parameters.add(token.trim());
        }
        if (state <= 3) {
            throw new RuntimeException("[syntax error] malformed term in line: " + line);
        }
        try {
            Term result = (Term)FactoryManager.instance().term().constructObject(termClass);
            result.updateReference(engine);
            result.setName(Op.validName(name));
            String separator = " ";
            if (result instanceof Function) {
                separator = "";
            }
            result.configure(Op.join(parameters, separator));
            return result;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected Defuzzifier parseDefuzzifier(String line) {
        String name;
        List<String> token = Op.split(line, ":");
        if (token.size() != 2) {
            throw new RuntimeException("[syntax error] expected property of type (key : value) in line: " + line);
        }
        String className = name = token.get(1).trim();
        if ("NONE".equals(name)) {
            className = "";
        }
        if ("COG".equals(className)) {
            className = Centroid.class.getSimpleName();
        } else if ("COA".equals(className)) {
            className = Bisector.class.getSimpleName();
        } else if ("LM".equals(className)) {
            className = SmallestOfMaximum.class.getSimpleName();
        } else if ("RM".equals(className)) {
            className = LargestOfMaximum.class.getSimpleName();
        } else if ("MM".equals(className)) {
            className = MeanOfMaximum.class.getSimpleName();
        } else if ("COGS".equals(className)) {
            className = WeightedAverage.class.getSimpleName();
        } else if ("COGSS".equals(className)) {
            className = WeightedSum.class.getSimpleName();
        }
        return (Defuzzifier)FactoryManager.instance().defuzzifier().constructObject(className);
    }

    protected Op.Pair<Double, Boolean> parseDefaultValue(String line) {
        double value;
        List<String> token = Op.split(line, ":=");
        if (token.size() != 2) {
            throw new RuntimeException("[syntax error] expected property of type (key := value) in line: " + line);
        }
        List<String> values = Op.split(token.get(1), "|");
        String defaultValue = values.get(0).trim();
        String nc = "";
        if (values.size() == 2) {
            nc = values.get(1).trim();
        }
        try {
            value = Op.toDouble(defaultValue);
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("[syntax error] expected numeric value, but found <%s> in line %s", defaultValue, line));
        }
        boolean lockPreviousOutput = nc.equals("NC");
        if (!lockPreviousOutput && !nc.isEmpty()) {
            throw new RuntimeException(String.format("[syntax error] expected keyword <NC>, but found <%s> in line: %s", nc, line));
        }
        return new Op.Pair<Double, Boolean>(value, lockPreviousOutput);
    }

    protected Op.Pair<Double, Double> parseRange(String line) {
        double maximum;
        double minimum;
        List<String> token = Op.split(line, ":=");
        if (token.size() != 2) {
            throw new RuntimeException("[syntax error] expected property of type (key := value) in line: " + line);
        }
        String rangeToken = token.get(1);
        StringBuilder range = new StringBuilder();
        for (char c : rangeToken.toCharArray()) {
            if (c == '(' || c == ')' || c == ' ' || c == ';') continue;
            range.append(c);
        }
        token = Op.split(range.toString(), "..");
        if (token.size() != 2) {
            throw new RuntimeException(String.format("[syntax error] expected property of type 'start .. end', but found <%s> in line: %s", range.toString(), line));
        }
        int index = -1;
        try {
            index = 0;
            minimum = Op.toDouble(token.get(0));
            index = 1;
            maximum = Op.toDouble(token.get(1));
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("[syntax error] expected numeric value, but found <%s> in line %s", token.get(index), line));
        }
        return new Op.Pair<Double, Double>(minimum, maximum);
    }

    protected Op.Pair<Boolean, Boolean> parseLocks(String line) {
        boolean range;
        boolean output;
        int index = line.indexOf(58);
        if (index < 0) {
            throw new RuntimeException("[syntax error] expected property of type 'key : value' in line: " + line);
        }
        String value = line.substring(index + 1);
        List<String> flags = Op.split(value, "|");
        if (flags.size() == 1) {
            String flag = flags.get(0).trim();
            output = "PREVIOUS".equals(flag);
            range = "RANGE".equals(flag);
            if (!output && !range) {
                throw new RuntimeException(String.format("[syntax error] expected locking flags <PREVIOUS|RANGE>, but found <%s> in line: %s", flag, line));
            }
        } else if (flags.size() == 2) {
            String flagA = flags.get(0).trim();
            String flagB = flags.get(1).trim();
            output = "PREVIOUS".equals(flagA) || "PREVIOUS".equals(flagB);
            boolean bl = range = "RANGE".equals(flagA) || "RANGE".equals(flagB);
            if (!output || !range) {
                throw new RuntimeException(String.format("[syntax error] expected locking flags <PREVIOUS|RANGE>, but found <%s|%s> in line %s", flags.get(0), flags.get(1), line));
            }
        } else {
            throw new RuntimeException(String.format("[syntax error] expected locking flags <PREVIOUS|RANGE>, but found <%s> in line %s", value, line));
        }
        return new Op.Pair<Boolean, Boolean>(output, range);
    }

    protected boolean parseEnabled(String line) {
        List<String> tokens = Op.split(line, ":");
        if (tokens.size() != 2) {
            throw new RuntimeException("[syntax error] expected property of type (key : value) in line: " + line);
        }
        String bool = tokens.get(1).trim();
        if ("TRUE".equals(bool)) {
            return true;
        }
        if ("FALSE".equals(bool)) {
            return false;
        }
        throw new RuntimeException("[syntax error] expected boolean <TRUE|FALSE>, but found <" + line + ">");
    }

    @Override
    public FclImporter clone() throws CloneNotSupportedException {
        return (FclImporter)super.clone();
    }
}

