/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.imex;

import com.fuzzylite.Engine;
import com.fuzzylite.Op;
import com.fuzzylite.activation.General;
import com.fuzzylite.defuzzifier.Bisector;
import com.fuzzylite.defuzzifier.Centroid;
import com.fuzzylite.defuzzifier.LargestOfMaximum;
import com.fuzzylite.defuzzifier.MeanOfMaximum;
import com.fuzzylite.defuzzifier.SmallestOfMaximum;
import com.fuzzylite.defuzzifier.WeightedAverage;
import com.fuzzylite.defuzzifier.WeightedSum;
import com.fuzzylite.factory.FactoryManager;
import com.fuzzylite.hedge.Any;
import com.fuzzylite.hedge.Extremely;
import com.fuzzylite.hedge.Not;
import com.fuzzylite.hedge.Seldom;
import com.fuzzylite.hedge.Somewhat;
import com.fuzzylite.hedge.Very;
import com.fuzzylite.imex.Importer;
import com.fuzzylite.norm.s.AlgebraicSum;
import com.fuzzylite.norm.s.BoundedSum;
import com.fuzzylite.norm.s.DrasticSum;
import com.fuzzylite.norm.s.EinsteinSum;
import com.fuzzylite.norm.s.HamacherSum;
import com.fuzzylite.norm.s.Maximum;
import com.fuzzylite.norm.s.NilpotentMaximum;
import com.fuzzylite.norm.s.NormalizedSum;
import com.fuzzylite.norm.s.UnboundedSum;
import com.fuzzylite.norm.t.AlgebraicProduct;
import com.fuzzylite.norm.t.BoundedDifference;
import com.fuzzylite.norm.t.DrasticProduct;
import com.fuzzylite.norm.t.EinsteinProduct;
import com.fuzzylite.norm.t.HamacherProduct;
import com.fuzzylite.norm.t.Minimum;
import com.fuzzylite.norm.t.NilpotentMinimum;
import com.fuzzylite.rule.Rule;
import com.fuzzylite.rule.RuleBlock;
import com.fuzzylite.term.Bell;
import com.fuzzylite.term.Binary;
import com.fuzzylite.term.Concave;
import com.fuzzylite.term.Constant;
import com.fuzzylite.term.Cosine;
import com.fuzzylite.term.Discrete;
import com.fuzzylite.term.Function;
import com.fuzzylite.term.Gaussian;
import com.fuzzylite.term.GaussianProduct;
import com.fuzzylite.term.Linear;
import com.fuzzylite.term.PiShape;
import com.fuzzylite.term.Ramp;
import com.fuzzylite.term.Rectangle;
import com.fuzzylite.term.SShape;
import com.fuzzylite.term.Sigmoid;
import com.fuzzylite.term.SigmoidDifference;
import com.fuzzylite.term.SigmoidProduct;
import com.fuzzylite.term.Spike;
import com.fuzzylite.term.Term;
import com.fuzzylite.term.Trapezoid;
import com.fuzzylite.term.Triangle;
import com.fuzzylite.term.ZShape;
import com.fuzzylite.variable.InputVariable;
import com.fuzzylite.variable.OutputVariable;
import com.fuzzylite.variable.Variable;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class FisImporter
extends Importer {
    protected static final int AND = 0;
    protected static final int OR = 1;
    protected static final int IMP = 2;
    protected static final int AGG = 3;
    protected static final int DEFUZZ = 4;
    protected static final int ALL = 5;

    @Override
    public Engine fromString(String fis) {
        Engine engine = new Engine();
        BufferedReader fisReader = new BufferedReader(new StringReader(fis));
        int lineNumber = 0;
        ArrayList<String> sections = new ArrayList<String>();
        try {
            String line;
            while ((line = fisReader.readLine()) != null) {
                ++lineNumber;
                line = Op.split(line, "//", false).get(0);
                line = Op.split(line, "#", false).get(0);
                if ((line = line.trim()).isEmpty() || line.charAt(0) == '%') continue;
                if ((line = line.replaceAll(Pattern.quote("'"), "")).startsWith("[System]") || line.startsWith("[Input") || line.startsWith("[Output") || line.startsWith("[Rules]")) {
                    sections.add(line);
                    continue;
                }
                if (!sections.isEmpty()) {
                    int lastIndex = sections.size() - 1;
                    String section = (String)sections.get(lastIndex);
                    section = section + "\n" + line;
                    sections.set(lastIndex, section);
                    continue;
                }
                throw new RuntimeException(String.format("[import error] line %d <%s> does not belong to any section", lineNumber, line));
            }
            String[] configuration = new String[5];
            for (String section : sections) {
                if (section.startsWith("[System]")) {
                    this.importSystem(section, engine, configuration);
                } else if (section.startsWith("[Input")) {
                    this.importInput(section, engine);
                } else if (section.startsWith("[Output")) {
                    this.importOutput(section, engine);
                } else if (section.startsWith("[Rules]")) {
                    this.importRules(section, engine);
                } else {
                    throw new RuntimeException(String.format("[import error] section not recognized: %s", section));
                }
                engine.configure(this.translateTNorm(configuration[0]), this.translateSNorm(configuration[1]), this.translateTNorm(configuration[2]), this.translateSNorm(configuration[3]), this.translateDefuzzifier(configuration[4]), General.class.getSimpleName());
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return engine;
    }

    protected void importSystem(String section, Engine engine, String[] methods) throws Exception {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(section));
        reader.readLine();
        while ((line = reader.readLine()) != null) {
            List<String> keyValue = Op.split(line, "=");
            String key = keyValue.get(0).trim();
            StringBuilder valueBuilder = new StringBuilder();
            for (int i = 1; i < keyValue.size(); ++i) {
                valueBuilder.append(keyValue.get(i));
            }
            String value = valueBuilder.toString().trim();
            if ("Name".equals(key)) {
                engine.setName(value);
                continue;
            }
            if ("AndMethod".equals(key)) {
                methods[0] = value;
                continue;
            }
            if ("OrMethod".equals(key)) {
                methods[1] = value;
                continue;
            }
            if ("ImpMethod".equals(key)) {
                methods[2] = value;
                continue;
            }
            if ("AggMethod".equals(key)) {
                methods[3] = value;
                continue;
            }
            if ("DefuzzMethod".equals(key)) {
                methods[4] = value;
                continue;
            }
            if ("Type".equals(key) || "Version".equals(key) || "NumInputs".equals(key) || "NumOutputs".equals(key) || "NumRules".equals(key) || "NumMFs".equals(key)) continue;
            throw new RuntimeException(String.format("[import error] token <%s> not recognized", key));
        }
    }

    protected void importInput(String section, Engine engine) throws Exception {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(section));
        reader.readLine();
        InputVariable inputVariable = new InputVariable();
        engine.addInputVariable(inputVariable);
        while ((line = reader.readLine()) != null) {
            List<String> keyValue = Op.split(line, "=");
            if (keyValue.size() != 2) {
                throw new RuntimeException(String.format("[syntax error] expected a property of type 'key=value', but found <%s>", line));
            }
            String key = keyValue.get(0).trim();
            String value = keyValue.get(1).trim();
            if ("Name".equals(key)) {
                inputVariable.setName(Op.validName(value));
                continue;
            }
            if ("Enabled".equals(key)) {
                inputVariable.setEnabled(Op.isEq(Op.toDouble(value), 1.0));
                continue;
            }
            if ("Range".equals(key)) {
                Op.Pair<Double, Double> minmax = this.parseRange(value);
                inputVariable.setMinimum(minmax.getFirst());
                inputVariable.setMaximum(minmax.getSecond());
                continue;
            }
            if (key.startsWith("MF")) {
                inputVariable.addTerm(this.parseTerm(value, engine));
                continue;
            }
            if ("NumMFs".equals(key)) continue;
            throw new RuntimeException(String.format("[import error] token <%s> not recognized", key));
        }
    }

    protected void importOutput(String section, Engine engine) throws Exception {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(section));
        reader.readLine();
        OutputVariable outputVariable = new OutputVariable();
        engine.addOutputVariable(outputVariable);
        while ((line = reader.readLine()) != null) {
            List<String> keyValue = Op.split(line, "=");
            if (keyValue.size() != 2) {
                throw new RuntimeException(String.format("[syntax error] expected a property of type 'key=value', but found <%s>", line));
            }
            String key = keyValue.get(0).trim();
            String value = keyValue.get(1).trim();
            if ("Name".equals(key)) {
                outputVariable.setName(Op.validName(value));
                continue;
            }
            if ("Enabled".equals(key)) {
                outputVariable.setEnabled(Op.isEq(Op.toDouble(value), 1.0));
                continue;
            }
            if ("Range".equals(key)) {
                Op.Pair<Double, Double> minmax = this.parseRange(value);
                outputVariable.setMinimum(minmax.getFirst());
                outputVariable.setMaximum(minmax.getSecond());
                continue;
            }
            if (key.startsWith("MF")) {
                outputVariable.addTerm(this.parseTerm(value, engine));
                continue;
            }
            if ("Default".equals(key)) {
                outputVariable.setDefaultValue(Op.toDouble(value));
                continue;
            }
            if ("LockPrevious".equals(key)) {
                outputVariable.setLockPreviousValue(Op.isEq(Op.toDouble(value), 1.0));
                continue;
            }
            if ("LockRange".equals(key)) {
                outputVariable.setLockValueInRange(Op.isEq(Op.toDouble(value), 1.0));
                continue;
            }
            if ("NumMFs".equals(key)) continue;
            throw new RuntimeException(String.format("[import error] token <%s> not recognized", key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importRules(String section, Engine engine) throws Exception {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(section));
        reader.readLine();
        RuleBlock ruleBlock = new RuleBlock();
        engine.addRuleBlock(ruleBlock);
        while ((line = reader.readLine()) != null) {
            String proposition;
            int i;
            List<String> inputsAndRest = Op.split(line, ",");
            if (inputsAndRest.size() != 2) {
                throw new RuntimeException(String.format("[syntax error] expected rule to match pattern <'i '+, 'o '+ (w) : '1|2'>, but found instead <%s>", line));
            }
            List<String> outputsAndRest = Op.split(inputsAndRest.get(1), ":");
            if (outputsAndRest.size() != 2) {
                throw new RuntimeException(String.format("[syntax error] expected rule to match pattern <'i '+, 'o '+ (w) : '1|2'>, but found instead <%s>", line));
            }
            List<String> inputs = Op.split(inputsAndRest.get(0).trim(), " ");
            List<String> outputs = Op.split(outputsAndRest.get(0).trim(), " ");
            String weightInParenthesis = outputs.get(outputs.size() - 1);
            outputs.remove(outputs.size() - 1);
            String connector = outputsAndRest.get(1).trim();
            if (inputs.size() != engine.numberOfInputVariables()) {
                throw new RuntimeException(String.format("[syntax error] expected <%d> input variables, but found <%d> input variables in rule <%s>", engine.numberOfInputVariables(), inputs.size(), line));
            }
            if (outputs.size() != engine.numberOfOutputVariables()) {
                throw new RuntimeException(String.format("[syntax error] expected <%d> output variables, but found <%d> output variables in rule <%s>", engine.numberOfOutputVariables(), outputs.size(), line));
            }
            ArrayList<String> antecedent = new ArrayList<String>();
            ArrayList<String> consequent = new ArrayList<String>();
            for (i = 0; i < inputs.size(); ++i) {
                double inputCode = Op.toDouble(inputs.get(i));
                if (Op.isEq(inputCode, 0.0)) continue;
                InputVariable inputVariable = engine.getInputVariable(i);
                proposition = String.format("%s %s %s", inputVariable.getName(), "is", this.translateProposition(inputCode, inputVariable));
                antecedent.add(proposition);
            }
            for (i = 0; i < outputs.size(); ++i) {
                double outputCode = Op.toDouble(outputs.get(i));
                if (Op.isEq(outputCode, 0.0)) continue;
                OutputVariable outputVariable = engine.getOutputVariable(i);
                proposition = String.format("%s %s %s", outputVariable.getName(), "is", this.translateProposition(outputCode, outputVariable));
                consequent.add(proposition);
            }
            StringBuilder ruleText = new StringBuilder();
            ruleText.append("if").append(" ");
            Iterator it = antecedent.iterator();
            while (it.hasNext()) {
                ruleText.append((String)it.next());
                if (!it.hasNext()) continue;
                ruleText.append(" ");
                if ("1".equals(connector)) {
                    ruleText.append("and").append(" ");
                    continue;
                }
                if ("2".equals(connector)) {
                    ruleText.append("or").append(" ");
                    continue;
                }
                throw new RuntimeException(String.format("[syntax error] connector <%s> not recognized", connector));
            }
            ruleText.append(String.format(" %s ", "then"));
            it = consequent.iterator();
            while (it.hasNext()) {
                ruleText.append((String)it.next());
                if (!it.hasNext()) continue;
                ruleText.append(String.format(" %s ", "and"));
            }
            StringBuilder weightBuilder = new StringBuilder();
            for (char c : weightInParenthesis.toCharArray()) {
                if (c == '(' || c == ')' || c == ' ') continue;
                weightBuilder.append(c);
            }
            String weightString = weightBuilder.toString();
            double weight = Op.toDouble(weightString);
            if (!Op.isEq(weight, 1.0)) {
                ruleText.append(String.format(" %s %s", "with", Op.str(weight)));
            }
            Rule rule = new Rule(ruleText.toString());
            try {
                rule.load(engine);
            }
            finally {
                ruleBlock.addRule(rule);
            }
        }
    }

    protected String translateProposition(double code, Variable variable) {
        int intPart = (int)Math.floor(Math.abs(code)) - 1;
        double fracPart = Math.abs(code) % 1.0;
        if (intPart > variable.numberOfTerms()) {
            throw new RuntimeException(String.format("[syntax error] the code <%s> refers to a term out of range from variable <%s>", Op.str(code), variable.getName()));
        }
        boolean isAny = intPart < 0;
        StringBuilder result = new StringBuilder();
        if (code < 0.0) {
            result.append(new Not().getName()).append(" ");
        }
        if (Op.isEq(fracPart, 0.01)) {
            result.append(new Seldom().getName()).append(" ");
        } else if (Op.isEq(fracPart, 0.05)) {
            result.append(new Somewhat().getName()).append(" ");
        } else if (Op.isEq(fracPart, 0.2)) {
            result.append(new Very().getName()).append(" ");
        } else if (Op.isEq(fracPart, 0.3)) {
            result.append(new Extremely().getName()).append(" ");
        } else if (Op.isEq(fracPart, 0.4)) {
            result.append(new Very().getName()).append(" ");
            result.append(new Very().getName()).append(" ");
        } else if (Op.isEq(fracPart, 0.99)) {
            result.append(new Any().getName()).append(" ");
        } else if (!Op.isEq(fracPart, 0.0)) {
            throw new RuntimeException(String.format("[syntax error] no hedge defined in FIS format for <%s>", Op.str(fracPart)));
        }
        if (!isAny) {
            result.append(variable.getTerm(intPart).getName());
        }
        return result.toString();
    }

    protected String translateTNorm(String name) {
        if ("min".equals(name)) {
            return Minimum.class.getSimpleName();
        }
        if ("prod".equals(name)) {
            return AlgebraicProduct.class.getSimpleName();
        }
        if ("bounded_difference".equals(name)) {
            return BoundedDifference.class.getSimpleName();
        }
        if ("drastic_product".equals(name)) {
            return DrasticProduct.class.getSimpleName();
        }
        if ("einstein_product".equals(name)) {
            return EinsteinProduct.class.getSimpleName();
        }
        if ("hamacher_product".equals(name)) {
            return HamacherProduct.class.getSimpleName();
        }
        if ("nilpotent_minimum".equals(name)) {
            return NilpotentMinimum.class.getSimpleName();
        }
        return name;
    }

    protected String translateSNorm(String name) {
        if ("max".equals(name)) {
            return Maximum.class.getSimpleName();
        }
        if ("probor".equals(name)) {
            return AlgebraicSum.class.getSimpleName();
        }
        if ("bounded_sum".equals(name)) {
            return BoundedSum.class.getSimpleName();
        }
        if ("normalized_sum".equals(name)) {
            return NormalizedSum.class.getSimpleName();
        }
        if ("drastic_sum".equals(name)) {
            return DrasticSum.class.getSimpleName();
        }
        if ("einstein_sum".equals(name)) {
            return EinsteinSum.class.getSimpleName();
        }
        if ("hamacher_sum".equals(name)) {
            return HamacherSum.class.getSimpleName();
        }
        if ("nilpotent_maximum".equals(name)) {
            return NilpotentMaximum.class.getSimpleName();
        }
        if ("sum".equals(name)) {
            return UnboundedSum.class.getSimpleName();
        }
        return name;
    }

    protected String translateDefuzzifier(String name) {
        if ("centroid".equals(name)) {
            return Centroid.class.getSimpleName();
        }
        if ("bisector".equals(name)) {
            return Bisector.class.getSimpleName();
        }
        if ("lom".equals(name)) {
            return LargestOfMaximum.class.getSimpleName();
        }
        if ("mom".equals(name)) {
            return MeanOfMaximum.class.getSimpleName();
        }
        if ("som".equals(name)) {
            return SmallestOfMaximum.class.getSimpleName();
        }
        if ("wtaver".equals(name)) {
            return WeightedAverage.class.getSimpleName();
        }
        if ("wtsum".equals(name)) {
            return WeightedSum.class.getSimpleName();
        }
        return name;
    }

    protected Op.Pair<Double, Double> parseRange(String range) {
        List<String> minmax = Op.split(range, " ");
        if (minmax.size() != 2) {
            throw new RuntimeException(String.format("[syntax error] expected range in format '[begin end]', but found <%s>", range));
        }
        String begin = minmax.get(0);
        String end = minmax.get(1);
        if (begin.charAt(0) != '[' || end.charAt(end.length() - 1) != ']') {
            throw new RuntimeException(String.format("[syntax error] expected range in format '[begin end]', but found <%s>", range));
        }
        Op.Pair<Double, Double> result = new Op.Pair<Double, Double>();
        result.setFirst(Op.toDouble(begin.substring(1)));
        result.setSecond(Op.toDouble(end.substring(0, end.length() - 1)));
        return result;
    }

    protected Term parseTerm(String fis, Engine engine) {
        StringBuilder lineBuilder = new StringBuilder();
        for (char c : fis.toCharArray()) {
            if (c == '[' || c == ']') continue;
            lineBuilder.append(c);
        }
        String line = lineBuilder.toString();
        List<String> nameTerm = Op.split(line, ":");
        if (nameTerm.size() != 2) {
            throw new RuntimeException(String.format("[syntax error] expected term in format 'name':'class',[params], but found <%s>", line));
        }
        List<String> termParams = Op.split(nameTerm.get(1), ",");
        if (termParams.size() != 2) {
            throw new RuntimeException(String.format("[syntax error] expected term in format 'name':'class',[params], but found <%s>", line));
        }
        List<String> parameters = Op.split(termParams.get(1), " ");
        for (int i = 0; i < parameters.size(); ++i) {
            parameters.set(i, parameters.get(i).trim());
        }
        return this.createInstance(termParams.get(0).trim(), nameTerm.get(0).trim(), parameters, engine);
    }

    protected Term createInstance(String mClass, String name, List<String> parameters, Engine engine) {
        HashMap<String, String> mapping = new HashMap<String, String>();
        mapping.put("gbellmf", Bell.class.getSimpleName());
        mapping.put("binarymf", Binary.class.getSimpleName());
        mapping.put("concavemf", Concave.class.getSimpleName());
        mapping.put("constant", Constant.class.getSimpleName());
        mapping.put("cosinemf", Cosine.class.getSimpleName());
        mapping.put("function", Function.class.getSimpleName());
        mapping.put("discretemf", Discrete.class.getSimpleName());
        mapping.put("gaussmf", Gaussian.class.getSimpleName());
        mapping.put("gauss2mf", GaussianProduct.class.getSimpleName());
        mapping.put("linear", Linear.class.getSimpleName());
        mapping.put("pimf", PiShape.class.getSimpleName());
        mapping.put("rampmf", Ramp.class.getSimpleName());
        mapping.put("rectmf", Rectangle.class.getSimpleName());
        mapping.put("smf", SShape.class.getSimpleName());
        mapping.put("sigmf", Sigmoid.class.getSimpleName());
        mapping.put("dsigmf", SigmoidDifference.class.getSimpleName());
        mapping.put("psigmf", SigmoidProduct.class.getSimpleName());
        mapping.put("spikemf", Spike.class.getSimpleName());
        mapping.put("trapmf", Trapezoid.class.getSimpleName());
        mapping.put("trimf", Triangle.class.getSimpleName());
        mapping.put("zmf", ZShape.class.getSimpleName());
        ArrayList<String> sortedParameters = new ArrayList<String>(parameters);
        if ("gbellmf".equals(mClass) && parameters.size() >= 3) {
            sortedParameters.set(0, parameters.get(2));
            sortedParameters.set(1, parameters.get(0));
            sortedParameters.set(2, parameters.get(1));
        } else if ("gaussmf".equals(mClass) && parameters.size() >= 2) {
            sortedParameters.set(0, parameters.get(1));
            sortedParameters.set(1, parameters.get(0));
        } else if ("gauss2mf".equals(mClass) && parameters.size() >= 4) {
            sortedParameters.set(0, parameters.get(1));
            sortedParameters.set(1, parameters.get(0));
            sortedParameters.set(2, parameters.get(3));
            sortedParameters.set(3, parameters.get(2));
        } else if ("sigmf".equals(mClass) && parameters.size() >= 2) {
            sortedParameters.set(0, parameters.get(1));
            sortedParameters.set(1, parameters.get(0));
        } else if ("dsigmf".equals(mClass) && parameters.size() >= 4) {
            sortedParameters.set(0, parameters.get(1));
            sortedParameters.set(1, parameters.get(0));
            sortedParameters.set(2, parameters.get(2));
            sortedParameters.set(3, parameters.get(3));
        } else if ("psigmf".equals(mClass) && parameters.size() >= 4) {
            sortedParameters.set(0, parameters.get(1));
            sortedParameters.set(1, parameters.get(0));
            sortedParameters.set(2, parameters.get(2));
            sortedParameters.set(3, parameters.get(3));
        }
        String flClass = (String)mapping.get(mClass);
        if (flClass == null) {
            flClass = mClass;
        }
        Term term = (Term)FactoryManager.instance().term().constructObject(flClass);
        term.updateReference(engine);
        term.setName(Op.validName(name));
        String separator = " ";
        if (term instanceof Function) {
            separator = "";
        }
        term.configure(Op.join(sortedParameters, separator));
        return term;
    }

    @Override
    public FisImporter clone() throws CloneNotSupportedException {
        return (FisImporter)super.clone();
    }
}

