/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.imex;

import com.fuzzylite.Engine;
import com.fuzzylite.FuzzyLite;
import com.fuzzylite.Op;
import com.fuzzylite.imex.Exporter;
import com.fuzzylite.variable.InputVariable;
import com.fuzzylite.variable.OutputVariable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class FldExporter
extends Exporter {
    private String separator;
    private boolean exportHeaders;
    private boolean exportInputValues;
    private boolean exportOutputValues;

    public FldExporter() {
        this(" ");
    }

    public FldExporter(String separator) {
        this.separator = separator;
        this.exportHeaders = true;
        this.exportInputValues = true;
        this.exportOutputValues = true;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public boolean exportsHeader() {
        return this.exportHeaders;
    }

    public void setExportHeader(boolean exportHeaders) {
        this.exportHeaders = exportHeaders;
    }

    public boolean exportsInputValues() {
        return this.exportInputValues;
    }

    public void setExportInputValues(boolean exportInputValues) {
        this.exportInputValues = exportInputValues;
    }

    public boolean exportsOutputValues() {
        return this.exportOutputValues;
    }

    public void setExportOutputValues(boolean exportOutputValues) {
        this.exportOutputValues = exportOutputValues;
    }

    public String header(Engine engine) {
        LinkedList<String> result = new LinkedList<String>();
        if (this.exportInputValues) {
            for (InputVariable inputVariable : engine.getInputVariables()) {
                result.add(inputVariable.getName());
            }
        }
        if (this.exportOutputValues) {
            for (OutputVariable outputVariable : engine.getOutputVariables()) {
                result.add(outputVariable.getName());
            }
        }
        return Op.join(result, this.separator);
    }

    @Override
    public String toString(Engine engine) {
        return this.toString(engine, 1024);
    }

    public String toString(Engine engine, int values) {
        return this.toString(engine, values, ScopeOfValues.AllVariables);
    }

    public String toString(Engine engine, int values, ScopeOfValues scope) {
        return this.toString(engine, values, scope, engine.getInputVariables());
    }

    public String toString(Engine engine, int values, ScopeOfValues scope, List<InputVariable> activeVariables) {
        StringWriter writer = new StringWriter();
        try {
            this.write(engine, writer, values, scope, activeVariables);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException("[exporter error] an exception occurred while exporting the results: " + ex);
        }
        return writer.toString();
    }

    public String toString(Engine engine, Reader reader) throws IOException {
        StringWriter writer = new StringWriter();
        if (this.exportHeaders) {
            writer.append(this.header(engine)).append("\n");
        }
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            String line;
            int lineNumber = 0;
            while ((line = bufferedReader.readLine()) != null) {
                List<Double> inputValues;
                block11: {
                    ++lineNumber;
                    if (!(line = line.trim()).isEmpty() && line.charAt(0) == '#') continue;
                    if (lineNumber == 1) {
                        try {
                            inputValues = this.parse(line);
                            break block11;
                        }
                        catch (Exception ex) {
                            continue;
                        }
                    }
                    inputValues = this.parse(line);
                }
                this.write(engine, (Writer)writer, inputValues, engine.getInputVariables());
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            bufferedReader.close();
        }
        return writer.toString();
    }

    public void toFile(File file, Engine engine, int values, ScopeOfValues scope) throws IOException {
        this.toFile(file, engine, values, scope, engine.getInputVariables());
    }

    public void toFile(File file, Engine engine, int values, ScopeOfValues scope, List<InputVariable> activeVariables) throws IOException {
        if (!file.createNewFile()) {
            FuzzyLite.logger().log(Level.FINE, "Replacing file {0}", file.getAbsolutePath());
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), FuzzyLite.UTF_8));
        try {
            this.write(engine, writer, values, scope, activeVariables);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            writer.close();
        }
    }

    public void toFile(File file, Engine engine, Reader reader) throws IOException {
        if (!file.createNewFile()) {
            FuzzyLite.logger().log(Level.FINE, "Replacing file {0}", file.getAbsolutePath());
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), FuzzyLite.UTF_8));
        if (this.exportHeaders) {
            writer.append(this.header(engine)).append("\n");
        }
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            String line;
            int lineNumber = 0;
            while ((line = bufferedReader.readLine()) != null) {
                List<Double> inputValues;
                block12: {
                    ++lineNumber;
                    if (!(line = line.trim()).isEmpty() && line.charAt(0) == '#') continue;
                    if (lineNumber == 1) {
                        try {
                            inputValues = this.parse(line);
                            break block12;
                        }
                        catch (Exception ex) {
                            continue;
                        }
                    }
                    inputValues = this.parse(line);
                }
                this.write(engine, (Writer)writer, inputValues, engine.getInputVariables());
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            bufferedReader.close();
            writer.close();
        }
    }

    public List<Double> parse(String values) {
        ArrayList<Double> inputValues = new ArrayList<Double>();
        if (!values.isEmpty() && values.charAt(0) != '#') {
            StringTokenizer tokenizer = new StringTokenizer(values);
            while (tokenizer.hasMoreTokens()) {
                inputValues.add(Op.toDouble(tokenizer.nextToken()));
            }
        }
        return inputValues;
    }

    public void write(Engine engine, Writer writer, int values, ScopeOfValues scope) throws IOException {
        this.write(engine, writer, values, scope, engine.getInputVariables());
    }

    public void write(Engine engine, Writer writer, int values, ScopeOfValues scope, List<InputVariable> activeVariables) throws IOException {
        if (this.exportHeaders) {
            writer.append(this.header(engine)).append("\n");
        }
        if (activeVariables.size() != engine.getInputVariables().size()) {
            throw new RuntimeException("[exporter error] number of active variables <" + activeVariables.size() + "> " + "must match the number of input variables in the engine " + "<" + engine.getInputVariables().size() + ">");
        }
        int resolution = scope == ScopeOfValues.AllVariables ? -1 + (int)Math.max(1.0, Math.pow(values, 1.0 / (double)engine.numberOfInputVariables())) : values - 1;
        int[] sampleValues = new int[engine.numberOfInputVariables()];
        int[] minSampleValues = new int[engine.numberOfInputVariables()];
        int[] maxSampleValues = new int[engine.numberOfInputVariables()];
        for (int i = 0; i < engine.numberOfInputVariables(); ++i) {
            sampleValues[i] = 0;
            minSampleValues[i] = 0;
            maxSampleValues[i] = engine.getInputVariable(i) == activeVariables.get(i) ? resolution : 0;
        }
        do {
            ArrayList<Double> inputValues = new ArrayList<Double>(engine.numberOfInputVariables());
            for (int i = 0; i < engine.numberOfInputVariables(); ++i) {
                InputVariable inputVariable = engine.getInputVariable(i);
                if (inputVariable == activeVariables.get(i)) {
                    inputValues.add(inputVariable.getMinimum() + (double)sampleValues[i] * inputVariable.range() / (double)Math.max(1, resolution));
                    continue;
                }
                inputValues.add(inputVariable.getValue());
            }
            this.write(engine, writer, inputValues, activeVariables);
        } while (Op.increment(sampleValues, minSampleValues, maxSampleValues));
    }

    public void write(Engine engine, Writer writer, Reader reader) throws IOException {
        if (this.exportHeaders) {
            writer.append(this.header(engine)).append("\n");
        }
        int lineNumber = 0;
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                List<Double> inputValues;
                block11: {
                    if (++lineNumber == 1) {
                        try {
                            inputValues = this.parse(line);
                            break block11;
                        }
                        catch (Exception ex) {
                            continue;
                        }
                    }
                    inputValues = this.parse(line);
                }
                this.write(engine, writer, inputValues, engine.getInputVariables());
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            bufferedReader.close();
        }
    }

    public void write(Engine engine, Writer writer, List<Double> inputValues, List<InputVariable> activeVariables) throws IOException {
        int i;
        if (inputValues.isEmpty()) {
            writer.append("\n");
            return;
        }
        if (inputValues.size() < engine.numberOfInputVariables()) {
            throw new RuntimeException(String.format("[export error] engine has <%d> input variables, but input data provides <%d> values", engine.numberOfInputVariables(), inputValues.size()));
        }
        if (activeVariables.size() != engine.getInputVariables().size()) {
            throw new RuntimeException(String.format("[exporter error] number of active variables <%d> must match the number of input variables in the engine <%d>", activeVariables.size(), engine.getInputVariables().size()));
        }
        ArrayList<Double> values = new ArrayList<Double>();
        for (i = 0; i < engine.numberOfInputVariables(); ++i) {
            InputVariable inputVariable = engine.getInputVariable(i);
            double inputValue = inputVariable == activeVariables.get(i) ? inputValues.get(i).doubleValue() : inputVariable.getValue();
            inputVariable.setValue(inputValue);
            if (!this.exportInputValues) continue;
            values.add(inputValue);
        }
        engine.process();
        for (i = 0; i < engine.numberOfOutputVariables(); ++i) {
            OutputVariable outputVariable = engine.getOutputVariable(i);
            if (!this.exportOutputValues) continue;
            values.add(outputVariable.getValue());
        }
        writer.append(Op.join(values, this.separator)).append("\n");
    }

    @Override
    public FldExporter clone() throws CloneNotSupportedException {
        return (FldExporter)super.clone();
    }

    public static enum ScopeOfValues {
        EachVariable,
        AllVariables;

    }
}

