/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.imex;

import com.fuzzylite.Engine;
import com.fuzzylite.Op;
import com.fuzzylite.activation.Activation;
import com.fuzzylite.defuzzifier.Defuzzifier;
import com.fuzzylite.defuzzifier.IntegralDefuzzifier;
import com.fuzzylite.defuzzifier.WeightedDefuzzifier;
import com.fuzzylite.imex.Exporter;
import com.fuzzylite.norm.Norm;
import com.fuzzylite.rule.Rule;
import com.fuzzylite.rule.RuleBlock;
import com.fuzzylite.term.Term;
import com.fuzzylite.variable.InputVariable;
import com.fuzzylite.variable.OutputVariable;
import com.fuzzylite.variable.Variable;
import java.util.Collection;
import java.util.LinkedList;

public class FllExporter
extends Exporter {
    private String indent;
    private String separator;

    public FllExporter() {
        this("  ", "\n");
    }

    public FllExporter(String indent, String separator) {
        this.indent = indent;
        this.separator = separator;
    }

    public String getIndent() {
        return this.indent;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    @Override
    public String toString(Engine engine) {
        LinkedList<String> result = new LinkedList<String>();
        result.add(String.format("Engine: %s", engine.getName()));
        if (!Op.isEmpty(engine.getDescription())) {
            result.add(String.format("%sdescription: %s", this.indent, engine.getDescription()));
        }
        for (InputVariable inputVariable : engine.getInputVariables()) {
            result.add(this.toString(inputVariable));
        }
        for (OutputVariable outputVariable : engine.getOutputVariables()) {
            result.add(this.toString(outputVariable));
        }
        for (RuleBlock ruleBlock : engine.getRuleBlocks()) {
            result.add(this.toString(ruleBlock));
        }
        return Op.join(result, this.separator);
    }

    public String toStringVariables(Collection<? extends Variable> variables) {
        LinkedList<String> result = new LinkedList<String>();
        for (Variable variable : variables) {
            result.add(this.toString(variable));
        }
        return Op.join(result, this.separator);
    }

    public String toStringInputVariables(Collection<InputVariable> variables) {
        LinkedList<String> result = new LinkedList<String>();
        for (InputVariable variable : variables) {
            result.add(this.toString(variable));
        }
        return Op.join(result, this.separator);
    }

    public String toStringOutputVariables(Collection<OutputVariable> variables) {
        LinkedList<String> result = new LinkedList<String>();
        for (OutputVariable variable : variables) {
            result.add(this.toString(variable));
        }
        return Op.join(result, this.separator);
    }

    public String toStringRuleBlocks(Collection<RuleBlock> ruleBlocks) {
        LinkedList<String> result = new LinkedList<String>();
        for (RuleBlock ruleBlock : ruleBlocks) {
            result.add(this.toString(ruleBlock));
        }
        return Op.join(result, this.separator);
    }

    public String toString(Variable variable) {
        LinkedList<String> result = new LinkedList<String>();
        result.add(String.format("Variable: %s", variable.getName()));
        if (!Op.isEmpty(variable.getDescription())) {
            result.add(String.format("%sdescription: %s", this.indent, variable.getDescription()));
        }
        result.add(String.format("%senabled: %s", this.indent, String.valueOf(variable.isEnabled())));
        result.add(String.format("%srange: %s", this.indent, Op.join(" ", variable.getMinimum(), variable.getMaximum())));
        result.add(String.format("%slock-range: %s", this.indent, String.valueOf(variable.isLockValueInRange())));
        for (Term term : variable.getTerms()) {
            result.add(String.format("%s%s", this.indent, this.toString(term)));
        }
        return Op.join(result, this.separator);
    }

    public String toString(InputVariable inputVariable) {
        LinkedList<String> result = new LinkedList<String>();
        result.add(String.format("InputVariable: %s", inputVariable.getName()));
        if (!Op.isEmpty(inputVariable.getDescription())) {
            result.add(String.format("%sdescription: %s", this.indent, inputVariable.getDescription()));
        }
        result.add(String.format("%senabled: %s", this.indent, String.valueOf(inputVariable.isEnabled())));
        result.add(String.format("%srange: %s", this.indent, Op.join(" ", inputVariable.getMinimum(), inputVariable.getMaximum())));
        result.add(String.format("%slock-range: %s", this.indent, String.valueOf(inputVariable.isLockValueInRange())));
        for (Term term : inputVariable.getTerms()) {
            result.add(String.format("%s%s", this.indent, this.toString(term)));
        }
        return Op.join(result, this.separator);
    }

    public String toString(OutputVariable outputVariable) {
        LinkedList<String> result = new LinkedList<String>();
        result.add(String.format("OutputVariable: %s", outputVariable.getName()));
        if (!Op.isEmpty(outputVariable.getDescription())) {
            result.add(String.format("%sdescription: %s", this.indent, outputVariable.getDescription()));
        }
        result.add(String.format("%senabled: %s", this.indent, String.valueOf(outputVariable.isEnabled())));
        result.add(String.format("%srange: %s", this.indent, Op.join(" ", outputVariable.getMinimum(), outputVariable.getMaximum())));
        result.add(String.format("%slock-range: %s", this.indent, String.valueOf(outputVariable.isLockValueInRange())));
        result.add(String.format("%saggregation: %s", this.indent, this.toString(outputVariable.fuzzyOutput().getAggregation())));
        result.add(String.format("%sdefuzzifier: %s", this.indent, this.toString(outputVariable.getDefuzzifier())));
        result.add(String.format("%sdefault: %s", this.indent, Op.str(outputVariable.getDefaultValue())));
        result.add(String.format("%slock-previous: %s", this.indent, String.valueOf(outputVariable.isLockPreviousValue())));
        for (Term term : outputVariable.getTerms()) {
            result.add(String.format("%s%s", this.indent, this.toString(term)));
        }
        return Op.join(result, this.separator);
    }

    public String toString(RuleBlock ruleBlock) {
        LinkedList<String> result = new LinkedList<String>();
        result.add(String.format("RuleBlock: %s", ruleBlock.getName()));
        if (!Op.isEmpty(ruleBlock.getDescription())) {
            result.add(String.format("%sdescription: %s", this.indent, ruleBlock.getDescription()));
        }
        result.add(String.format("%senabled: %s", this.indent, String.valueOf(ruleBlock.isEnabled())));
        result.add(String.format("%sconjunction: %s", this.indent, this.toString(ruleBlock.getConjunction())));
        result.add(String.format("%sdisjunction: %s", this.indent, this.toString(ruleBlock.getDisjunction())));
        result.add(String.format("%simplication: %s", this.indent, this.toString(ruleBlock.getImplication())));
        result.add(String.format("%sactivation: %s", this.indent, this.toString(ruleBlock.getActivation())));
        for (Rule rule : ruleBlock.getRules()) {
            result.add(String.format("%s%s", this.indent, this.toString(rule)));
        }
        return Op.join(result, this.separator);
    }

    public String toString(Rule rule) {
        return "rule: " + rule.getText();
    }

    public String toString(Term term) {
        return "term: " + term.getName() + " " + term.getClass().getSimpleName() + " " + term.parameters();
    }

    public String toString(Norm norm) {
        if (norm == null) {
            return "none";
        }
        return norm.getClass().getSimpleName();
    }

    public String toString(Activation activation) {
        if (activation == null) {
            return "none";
        }
        String className = activation.getClass().getSimpleName();
        if (activation.parameters().isEmpty()) {
            return className;
        }
        return className + " " + activation.parameters();
    }

    public String toString(Defuzzifier defuzzifier) {
        if (defuzzifier == null) {
            return "none";
        }
        String result = defuzzifier.getClass().getSimpleName();
        if (defuzzifier instanceof IntegralDefuzzifier) {
            return result + " " + ((IntegralDefuzzifier)defuzzifier).getResolution();
        }
        if (defuzzifier instanceof WeightedDefuzzifier) {
            return result + " " + ((WeightedDefuzzifier)defuzzifier).getType().toString();
        }
        return result;
    }

    @Override
    public FllExporter clone() throws CloneNotSupportedException {
        return (FllExporter)super.clone();
    }
}

