/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.imex;

import com.fuzzylite.Engine;
import com.fuzzylite.FuzzyLite;
import com.fuzzylite.Op;
import com.fuzzylite.activation.Activation;
import com.fuzzylite.activation.General;
import com.fuzzylite.defuzzifier.Defuzzifier;
import com.fuzzylite.defuzzifier.IntegralDefuzzifier;
import com.fuzzylite.defuzzifier.WeightedDefuzzifier;
import com.fuzzylite.factory.FactoryManager;
import com.fuzzylite.factory.TNormFactory;
import com.fuzzylite.imex.Importer;
import com.fuzzylite.norm.SNorm;
import com.fuzzylite.norm.TNorm;
import com.fuzzylite.rule.Rule;
import com.fuzzylite.rule.RuleBlock;
import com.fuzzylite.term.Term;
import com.fuzzylite.variable.InputVariable;
import com.fuzzylite.variable.OutputVariable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;

public class FllImporter
extends Importer {
    private String separator;

    public FllImporter() {
        this("\n");
    }

    public FllImporter(String separator) {
        this.separator = separator;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    @Override
    public Engine fromString(String code) {
        Engine engine = new Engine();
        String fll = Op.join(Op.split(code, this.getSeparator()), "\n");
        String tag = "";
        LinkedList<String> block = new LinkedList<String>();
        BufferedReader reader = new BufferedReader(new StringReader(fll));
        while (true) {
            String line;
            try {
                line = reader.readLine();
            }
            catch (IOException ex) {
                break;
            }
            if (line == null) break;
            int colon = (line = Op.split(line.trim(), "#", false).get(0)).indexOf(58);
            if (colon < 0) {
                throw new RuntimeException("[import error] expected a colon at here: " + line);
            }
            String key = line.substring(0, colon).trim();
            String value = line.substring(colon + 1).trim();
            if ("Engine".equals(key)) {
                engine.setName(value);
                continue;
            }
            if ("description".equals(key) && block.isEmpty()) {
                engine.setDescription(value);
                continue;
            }
            if ("InputVariable".equals(key) || "OutputVariable".equals(key) || "RuleBlock".equals(key)) {
                try {
                    this.process(tag, Op.join(block, "\n"), engine);
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                block.clear();
                tag = key;
            }
            block.add(key + ":" + value);
        }
        try {
            this.process(tag, Op.join(block, "\n"), engine);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
        return engine;
    }

    protected void process(String tag, String block, Engine engine) throws Exception {
        if (tag.isEmpty()) {
            return;
        }
        if ("InputVariable".equals(tag)) {
            this.processInputVariable(block, engine);
        } else if ("OutputVariable".equals(tag)) {
            this.processOutputVariable(block, engine);
        } else if ("RuleBlock".equals(tag)) {
            this.processRuleBlock(block, engine);
        } else {
            throw new RuntimeException("[import error] block tag <" + tag + "> " + "not recognized");
        }
    }

    protected void processInputVariable(String block, Engine engine) throws Exception {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(block));
        InputVariable inputVariable = new InputVariable();
        engine.addInputVariable(inputVariable);
        while ((line = reader.readLine()) != null) {
            Op.Pair<String, String> keyValue = this.parseKeyValue(line, ':');
            if ("InputVariable".equals(keyValue.getFirst())) {
                inputVariable.setName(keyValue.getSecond());
                continue;
            }
            if ("description".equals(keyValue.getFirst())) {
                inputVariable.setDescription(keyValue.getSecond());
                continue;
            }
            if ("enabled".equals(keyValue.getFirst())) {
                inputVariable.setEnabled(this.parseBoolean(keyValue.getSecond()));
                continue;
            }
            if ("range".equals(keyValue.getFirst())) {
                Op.Pair<Double, Double> range = this.parseRange(keyValue.getSecond());
                inputVariable.setRange(range.getFirst(), range.getSecond());
                continue;
            }
            if ("lock-range".equals(keyValue.getFirst())) {
                inputVariable.setLockValueInRange(this.parseBoolean(keyValue.getSecond()));
                continue;
            }
            if ("term".equals(keyValue.getFirst())) {
                inputVariable.addTerm(this.parseTerm(keyValue.getSecond(), engine));
                continue;
            }
            throw new RuntimeException("[import error] key <" + keyValue.getFirst() + "> " + "not recognized in pair <" + Op.join(":", keyValue.getFirst(), keyValue.getSecond()) + ">");
        }
        reader.close();
    }

    protected void processOutputVariable(String block, Engine engine) throws Exception {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(block));
        OutputVariable outputVariable = new OutputVariable();
        engine.addOutputVariable(outputVariable);
        while ((line = reader.readLine()) != null) {
            Op.Pair<String, String> keyValue = this.parseKeyValue(line, ':');
            if ("OutputVariable".equals(keyValue.getFirst())) {
                outputVariable.setName(keyValue.getSecond());
                continue;
            }
            if ("description".equals(keyValue.getFirst())) {
                outputVariable.setDescription(keyValue.getSecond());
                continue;
            }
            if ("enabled".equals(keyValue.getFirst())) {
                outputVariable.setEnabled(this.parseBoolean(keyValue.getSecond()));
                continue;
            }
            if ("range".equals(keyValue.getFirst())) {
                Op.Pair<Double, Double> range = this.parseRange(keyValue.getSecond());
                outputVariable.setRange(range.getFirst(), range.getSecond());
                continue;
            }
            if ("default".equals(keyValue.getFirst())) {
                outputVariable.setDefaultValue(Op.toDouble(keyValue.getSecond()));
                continue;
            }
            if ("lock-previous".equals(keyValue.getFirst())) {
                outputVariable.setLockPreviousValue(this.parseBoolean(keyValue.getSecond()));
                continue;
            }
            if ("lock-range".equals(keyValue.getFirst())) {
                outputVariable.setLockValueInRange(this.parseBoolean(keyValue.getSecond()));
                continue;
            }
            if ("defuzzifier".equals(keyValue.getFirst())) {
                outputVariable.setDefuzzifier(this.parseDefuzzifier(keyValue.getSecond()));
                continue;
            }
            if ("aggregation".equals(keyValue.getFirst())) {
                outputVariable.fuzzyOutput().setAggregation(this.parseSNorm(keyValue.getSecond()));
                continue;
            }
            if ("accumulation".equals(keyValue.getFirst())) {
                outputVariable.fuzzyOutput().setAggregation(this.parseSNorm(keyValue.getSecond()));
                FuzzyLite.logger().warning("[warning] obsolete usage of identifier <accumulation: SNorm> in OutputVariable");
                FuzzyLite.logger().info("[information] from version 6.0, the identifier <aggregation: SNorm> should be used");
                FuzzyLite.logger().log(Level.INFO, "[backward compatibility] assumed <aggregation: {0}> instead of <accumulation: {0}>", keyValue.getSecond());
                continue;
            }
            if ("term".equals(keyValue.getFirst())) {
                outputVariable.addTerm(this.parseTerm(keyValue.getSecond(), engine));
                continue;
            }
            throw new RuntimeException("[import error] key <" + keyValue.getFirst() + "> " + "not recognized in pair <" + Op.join(":", keyValue.getFirst(), keyValue.getSecond()) + ">");
        }
        reader.close();
    }

    protected void processRuleBlock(String block, Engine engine) throws Exception {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(block));
        RuleBlock ruleBlock = new RuleBlock();
        engine.addRuleBlock(ruleBlock);
        while ((line = reader.readLine()) != null) {
            Op.Pair<String, String> keyValue = this.parseKeyValue(line, ':');
            if ("RuleBlock".equals(keyValue.getFirst())) {
                ruleBlock.setName(keyValue.getSecond());
                continue;
            }
            if ("description".equals(keyValue.getFirst())) {
                ruleBlock.setDescription(keyValue.getSecond());
                continue;
            }
            if ("enabled".equals(keyValue.getFirst())) {
                ruleBlock.setEnabled(this.parseBoolean(keyValue.getSecond()));
                continue;
            }
            if ("conjunction".equals(keyValue.getFirst())) {
                ruleBlock.setConjunction(this.parseTNorm(keyValue.getSecond()));
                continue;
            }
            if ("disjunction".equals(keyValue.getFirst())) {
                ruleBlock.setDisjunction(this.parseSNorm(keyValue.getSecond()));
                continue;
            }
            if ("implication".equals(keyValue.getFirst())) {
                ruleBlock.setImplication(this.parseTNorm(keyValue.getSecond()));
                continue;
            }
            if ("activation".equals(keyValue.getFirst())) {
                TNormFactory tnorm = FactoryManager.instance().tnorm();
                if (tnorm.hasConstructor(keyValue.getSecond())) {
                    ruleBlock.setImplication(this.parseTNorm(keyValue.getSecond()));
                    FuzzyLite.logger().warning("[warning] obsolete usage of identifier <activation: TNorm> in RuleBlock");
                    FuzzyLite.logger().info("[information] from version 6.0, the identifier <implication: TNorm> should be used");
                    FuzzyLite.logger().log(Level.INFO, "[backward compatibility] assumed <implication: {0}> instead of <activation: {0}>", keyValue.getSecond());
                    continue;
                }
                ruleBlock.setActivation(this.parseActivation(keyValue.getSecond()));
                continue;
            }
            if ("rule".equals(keyValue.getFirst())) {
                Rule rule = new Rule();
                rule.setText(keyValue.getSecond());
                try {
                    rule.load(engine);
                }
                catch (Exception ex) {
                    FuzzyLite.logger().log(Level.INFO, "Error loading rule: {0}\n{1}", new String[]{rule.getText(), ex.toString()});
                }
                ruleBlock.addRule(rule);
                continue;
            }
            throw new RuntimeException("[import error] key <" + keyValue.getFirst() + "> " + "not recognized in pair <" + Op.join(":", keyValue.getFirst(), keyValue.getSecond()) + ">");
        }
        if (ruleBlock.getActivation() == null) {
            ruleBlock.setActivation(new General());
        }
        reader.close();
    }

    protected Term parseTerm(String text, Engine engine) {
        List<String> tokens = Op.split(text, " ");
        if (tokens.size() < 2) {
            throw new RuntimeException("[syntax error] expected a term in format <name class parameters>, but found <" + text + ">");
        }
        Term term = (Term)FactoryManager.instance().term().constructObject(tokens.get(1));
        term.updateReference(engine);
        term.setName(Op.validName(tokens.get(0)));
        StringBuilder parameters = new StringBuilder();
        for (int i = 2; i < tokens.size(); ++i) {
            parameters.append(tokens.get(i));
            if (i + 1 >= tokens.size()) continue;
            parameters.append(" ");
        }
        term.configure(parameters.toString());
        return term;
    }

    protected Activation parseActivation(String name) {
        if ("none".equals(name)) {
            return (Activation)FactoryManager.instance().activation().constructObject("");
        }
        List<String> tokens = Op.split(name, " ");
        Activation result = (Activation)FactoryManager.instance().activation().constructObject(tokens.get(0));
        LinkedList<String> parameters = new LinkedList<String>();
        for (int i = 1; i < tokens.size(); ++i) {
            parameters.add(tokens.get(i));
        }
        result.configure(Op.join(parameters, " "));
        return result;
    }

    protected TNorm parseTNorm(String name) {
        if ("none".equals(name)) {
            return (TNorm)FactoryManager.instance().tnorm().constructObject("");
        }
        return (TNorm)FactoryManager.instance().tnorm().constructObject(name);
    }

    protected SNorm parseSNorm(String name) {
        if ("none".equals(name)) {
            return (SNorm)FactoryManager.instance().snorm().constructObject("");
        }
        return (SNorm)FactoryManager.instance().snorm().constructObject(name);
    }

    protected Defuzzifier parseDefuzzifier(String text) {
        List<String> parameters = Op.split(text, " ");
        String name = parameters.get(0);
        if ("none".equals(name)) {
            return (Defuzzifier)FactoryManager.instance().defuzzifier().constructObject("");
        }
        Defuzzifier defuzzifier = (Defuzzifier)FactoryManager.instance().defuzzifier().constructObject(name);
        if (parameters.size() > 1) {
            String parameter = parameters.get(1);
            if (defuzzifier instanceof IntegralDefuzzifier) {
                ((IntegralDefuzzifier)defuzzifier).setResolution(Integer.parseInt(parameter));
            } else if (defuzzifier instanceof WeightedDefuzzifier) {
                ((WeightedDefuzzifier)defuzzifier).setType(WeightedDefuzzifier.Type.valueOf(parameter));
            }
        }
        return defuzzifier;
    }

    protected Op.Pair<Double, Double> parseRange(String text) {
        Op.Pair<String, String> range = this.parseKeyValue(text, ' ');
        return new Op.Pair<Double, Double>(Op.toDouble(range.getFirst()), Op.toDouble(range.getSecond()));
    }

    protected boolean parseBoolean(String bool) {
        if ("true".equals(bool)) {
            return true;
        }
        if ("false".equals(bool)) {
            return false;
        }
        throw new RuntimeException("[syntax error] expected boolean <true|false>, but found <" + bool + ">");
    }

    protected Op.Pair<String, String> parseKeyValue(String text, char separator) {
        int half = text.indexOf(separator);
        if (half < 0) {
            throw new RuntimeException("[syntax error] expected pair in the form <key" + separator + "value>, but found <" + text + ">");
        }
        Op.Pair<String, String> result = new Op.Pair<String, String>();
        result.setFirst(text.substring(0, half));
        result.setSecond(text.substring(half + 1));
        return result;
    }

    @Override
    public FllImporter clone() throws CloneNotSupportedException {
        return (FllImporter)super.clone();
    }
}

