/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.imex;

import com.fuzzylite.Engine;
import com.fuzzylite.FuzzyLite;
import com.fuzzylite.Op;
import com.fuzzylite.defuzzifier.Bisector;
import com.fuzzylite.defuzzifier.Centroid;
import com.fuzzylite.defuzzifier.Defuzzifier;
import com.fuzzylite.defuzzifier.LargestOfMaximum;
import com.fuzzylite.defuzzifier.MeanOfMaximum;
import com.fuzzylite.defuzzifier.SmallestOfMaximum;
import com.fuzzylite.defuzzifier.WeightedAverage;
import com.fuzzylite.defuzzifier.WeightedSum;
import com.fuzzylite.factory.FactoryManager;
import com.fuzzylite.imex.Exporter;
import com.fuzzylite.norm.Norm;
import com.fuzzylite.norm.SNorm;
import com.fuzzylite.norm.s.AlgebraicSum;
import com.fuzzylite.norm.s.BoundedSum;
import com.fuzzylite.norm.s.DrasticSum;
import com.fuzzylite.norm.s.EinsteinSum;
import com.fuzzylite.norm.s.HamacherSum;
import com.fuzzylite.norm.s.Maximum;
import com.fuzzylite.norm.s.NilpotentMaximum;
import com.fuzzylite.norm.s.NormalizedSum;
import com.fuzzylite.norm.t.AlgebraicProduct;
import com.fuzzylite.norm.t.BoundedDifference;
import com.fuzzylite.norm.t.DrasticProduct;
import com.fuzzylite.norm.t.EinsteinProduct;
import com.fuzzylite.norm.t.HamacherProduct;
import com.fuzzylite.norm.t.Minimum;
import com.fuzzylite.norm.t.NilpotentMinimum;
import com.fuzzylite.rule.Rule;
import com.fuzzylite.rule.RuleBlock;
import com.fuzzylite.term.Bell;
import com.fuzzylite.term.Constant;
import com.fuzzylite.term.Cosine;
import com.fuzzylite.term.Discrete;
import com.fuzzylite.term.Function;
import com.fuzzylite.term.Gaussian;
import com.fuzzylite.term.GaussianProduct;
import com.fuzzylite.term.Linear;
import com.fuzzylite.term.Ramp;
import com.fuzzylite.term.Sigmoid;
import com.fuzzylite.term.SigmoidDifference;
import com.fuzzylite.term.Term;
import com.fuzzylite.term.Trapezoid;
import com.fuzzylite.term.Triangle;
import com.fuzzylite.variable.InputVariable;
import com.fuzzylite.variable.OutputVariable;
import com.fuzzylite.variable.Variable;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class JflExporter
extends Exporter {
    private String indent;

    public JflExporter() {
        this("  ");
    }

    public JflExporter(String indent) {
        this.indent = indent;
    }

    public String getIndent() {
        return this.indent;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    @Override
    public String toString(Engine engine) {
        SNorm aggregation;
        StringBuilder result = new StringBuilder();
        result.append(String.format("FUNCTION_BLOCK %s\n", engine.getName()));
        result.append("\n");
        result.append("VAR_INPUT\n");
        for (InputVariable inputVariable : engine.getInputVariables()) {
            result.append(String.format(this.indent + "%s: REAL;\n", inputVariable.getName()));
        }
        result.append("END_VAR\n");
        result.append("\n");
        result.append("VAR_OUTPUT\n");
        for (OutputVariable outputVariable : engine.getOutputVariables()) {
            result.append(String.format(this.indent + "%s: REAL;\n", outputVariable.getName()));
        }
        result.append("END_VAR\n");
        result.append("\n");
        for (InputVariable inputVariable : engine.getInputVariables()) {
            result.append(this.toString(inputVariable)).append("\n");
        }
        HashSet<String> aggregationOperators = new HashSet<String>();
        for (OutputVariable outputVariable : engine.getOutputVariables()) {
            result.append(this.toString(outputVariable)).append("\n");
            aggregation = outputVariable.fuzzyOutput().getAggregation();
            if (aggregation == null) continue;
            aggregationOperators.add(aggregation.getClass().getSimpleName());
        }
        for (RuleBlock ruleBlock : engine.getRuleBlocks()) {
            if (aggregationOperators.size() > 1) {
                throw new RuntimeException("FCL supports only a single aggregation operator, but found <" + aggregationOperators.size() + ">: " + Op.join(aggregationOperators, " "));
            }
            aggregation = null;
            if (!aggregationOperators.isEmpty()) {
                aggregation = (SNorm)FactoryManager.instance().snorm().constructObject((String)aggregationOperators.iterator().next());
            }
            result.append(this.toString(ruleBlock, aggregation)).append("\n");
        }
        result.append("END_FUNCTION_BLOCK\n");
        return result.toString();
    }

    public String toString(InputVariable inputVariable) {
        StringBuilder result = new StringBuilder();
        result.append(String.format("FUZZIFY %s\n", inputVariable.getName()));
        for (Term term : inputVariable.getTerms()) {
            result.append(String.format(this.indent + "TERM %s := %s;\n", term.getName(), this.toString(term, inputVariable)));
        }
        result.append("END_FUZZIFY\n");
        return result.toString();
    }

    public String toString(OutputVariable outputVariable) {
        double defaultValue;
        StringBuilder result = new StringBuilder();
        result.append(String.format("DEFUZZIFY %s\n", outputVariable.getName()));
        for (Term term : outputVariable.getTerms()) {
            result.append(String.format(this.indent + "TERM %s := %s;\n", term.getName(), this.toString(term, outputVariable)));
        }
        if (outputVariable.getDefuzzifier() != null) {
            result.append(String.format(this.indent + "METHOD : %s;\n", this.toString(outputVariable.getDefuzzifier())));
        }
        if (Double.isNaN(defaultValue = outputVariable.getDefaultValue()) || Double.isInfinite(defaultValue)) {
            defaultValue = 0.0;
        }
        result.append(String.format(this.indent + "DEFAULT := %s", Op.str(defaultValue)));
        result.append(";\n");
        result.append("END_DEFUZZIFY\n");
        return result.toString();
    }

    public String toString(RuleBlock ruleBlock, SNorm aggregation) {
        StringWriter result = new StringWriter();
        String name = ruleBlock.getName();
        if (name.trim().isEmpty()) {
            name = "No1";
        }
        result.append(String.format("RULEBLOCK %s\n", name));
        if (ruleBlock.getConjunction() != null) {
            result.append(String.format(this.indent + "AND : %s;\n", this.toString(ruleBlock.getConjunction())));
        }
        if (ruleBlock.getDisjunction() != null) {
            result.append(String.format(this.indent + "OR : %s;\n", this.toString(ruleBlock.getDisjunction())));
        }
        if (ruleBlock.getImplication() != null) {
            result.append(String.format(this.indent + "ACT : %s;\n", this.toString(ruleBlock.getImplication())));
        }
        if (aggregation != null) {
            result.append(String.format(this.indent + "ACCU : %s;\n", this.toString(aggregation)));
        }
        int index = 0;
        for (Rule rule : ruleBlock.getRules()) {
            String[] consequents;
            ++index;
            String text = rule.getText();
            text = text.replaceFirst("\\s*if\\s+", " " + "if".toUpperCase() + " ");
            text = text.replaceAll("\\s+is\\s+", " " + "is".toUpperCase() + " ");
            text = text.replaceAll("\\s+and\\s+", " " + "and".toUpperCase() + " ");
            text = text.replaceAll("\\s+or\\s+", " " + "or".toUpperCase() + " ");
            text = text.replaceFirst("\\s+then\\s+", " " + "then".toUpperCase() + " ");
            String[] tokens = (text = text.replaceFirst("\\s+with\\s+", " " + "with".toUpperCase() + " ")).split(Pattern.quote(" " + "then".toUpperCase() + " "));
            if (tokens.length != 2) {
                throw new RuntimeException("Expected antecedent THEN consequent, but found: " + text);
            }
            String antecedent = tokens[0];
            for (String consequent : consequents = tokens[1].split(Pattern.quote(" " + "and".toUpperCase() + " "))) {
                result.append(this.indent + "RULE " + index + " : " + antecedent + " " + "then".toUpperCase() + " " + consequent + " ;\n");
            }
        }
        result.append("END_RULEBLOCK\n");
        return result.toString();
    }

    public String toString(Norm norm) {
        if (norm == null) {
            return "NONE";
        }
        if (norm instanceof Minimum) {
            return "MIN";
        }
        if (norm instanceof AlgebraicProduct) {
            return "PROD";
        }
        if (norm instanceof BoundedDifference) {
            return "BDIF";
        }
        if (norm instanceof DrasticProduct) {
            return "DPROD";
        }
        if (norm instanceof EinsteinProduct) {
            return "EPROD";
        }
        if (norm instanceof HamacherProduct) {
            return "HPROD";
        }
        if (norm instanceof NilpotentMinimum) {
            return "NMIN";
        }
        if (norm instanceof Maximum) {
            return "MAX";
        }
        if (norm instanceof AlgebraicSum) {
            return "ASUM";
        }
        if (norm instanceof NormalizedSum) {
            return "NSUM";
        }
        if (norm instanceof BoundedSum) {
            return "BSUM";
        }
        if (norm instanceof DrasticSum) {
            return "DSUM";
        }
        if (norm instanceof EinsteinSum) {
            return "ESUM";
        }
        if (norm instanceof HamacherSum) {
            return "HSUM";
        }
        if (norm instanceof NilpotentMaximum) {
            return "NMAX";
        }
        return norm.getClass().getSimpleName();
    }

    public String toString(Defuzzifier defuzzifier) {
        if (defuzzifier == null) {
            return "NONE";
        }
        if (defuzzifier instanceof Centroid) {
            return "COG";
        }
        if (defuzzifier instanceof Bisector) {
            return "COA";
        }
        if (defuzzifier instanceof SmallestOfMaximum) {
            return "LM";
        }
        if (defuzzifier instanceof LargestOfMaximum) {
            return "RM";
        }
        if (defuzzifier instanceof MeanOfMaximum) {
            return "MM";
        }
        if (defuzzifier instanceof WeightedAverage) {
            return "COGS";
        }
        if (defuzzifier instanceof WeightedSum) {
            return "COGSS";
        }
        return defuzzifier.getClass().getSimpleName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString(Term term, Variable variable) {
        if (term == null) {
            return "";
        }
        if (term instanceof Cosine) {
            Cosine cosine = (Cosine)term;
            return MessageFormat.format("COSINE {0} {1}", Op.str(cosine.getWidth()), Op.str(cosine.getCenter()));
        }
        if (term instanceof SigmoidDifference) {
            SigmoidDifference sigmoidDifference = (SigmoidDifference)term;
            return MessageFormat.format("DSIGM {0} {1} {2} {3}", Op.str(sigmoidDifference.getRising()), Op.str(sigmoidDifference.getLeft()), Op.str(sigmoidDifference.getFalling()), Op.str(sigmoidDifference.getRight()));
        }
        if (term instanceof Gaussian) {
            Gaussian gaussian = (Gaussian)term;
            return MessageFormat.format("GAUSS {0} {1}", Op.str(gaussian.getMean()), Op.str(gaussian.getStandardDeviation()));
        }
        if (term instanceof GaussianProduct) {
            GaussianProduct gaussianProduct = (GaussianProduct)term;
            return MessageFormat.format("GAUSS2 {0} {1} {2} {3}", Op.str(gaussianProduct.getMeanA()), Op.str(gaussianProduct.getStandardDeviationA()), Op.str(gaussianProduct.getMeanB()), Op.str(gaussianProduct.getStandardDeviationB()));
        }
        if (term instanceof Bell) {
            Bell bell = (Bell)term;
            return MessageFormat.format(" GBELL {0} {1} {2}", Op.str(bell.getWidth()), Op.str(bell.getSlope()), Op.str(bell.getCenter()));
        }
        if (term instanceof Sigmoid) {
            Sigmoid sigmoid = (Sigmoid)term;
            return MessageFormat.format("SIGM {0} {1}", Op.str(sigmoid.getSlope()), Op.str(sigmoid.getInflection()));
        }
        if (term instanceof Trapezoid) {
            Trapezoid trapezoid = (Trapezoid)term;
            return MessageFormat.format("TRAPE {0} {1} {2} {3}", Op.str(trapezoid.getVertexA()), Op.str(trapezoid.getVertexB()), Op.str(trapezoid.getVertexC()), Op.str(trapezoid.getVertexD()));
        }
        if (term instanceof Triangle) {
            Triangle triangle = (Triangle)term;
            return MessageFormat.format("TRIAN {0} {1} {2}", Op.str(triangle.getVertexA()), Op.str(triangle.getVertexB()), Op.str(triangle.getVertexC()));
        }
        if (term instanceof Ramp) {
            Ramp ramp = (Ramp)term;
            if (ramp.direction() == Ramp.Direction.Positive) {
                return MessageFormat.format("TRIAN {0} {1} {2}", Op.str(ramp.getStart()), Op.str(ramp.getEnd()), Op.str(ramp.getEnd()));
            }
            if (ramp.direction() != Ramp.Direction.Negative) throw new RuntimeException("FCL not available for: " + term.toString());
            return MessageFormat.format("TRIAN {0} {1} {2}", Op.str(ramp.getEnd()), Op.str(ramp.getEnd()), Op.str(ramp.getStart()));
        }
        if (term instanceof Discrete) {
            Discrete discrete = (Discrete)term;
            return Discrete.formatXY(discrete.getXY());
        }
        if (term instanceof Function) {
            Function function = (Function)term;
            String formula = function.getFormula();
            formula = formula.replaceAll("fabs\\(", "abs(");
            return "FUNCTION " + formula;
        }
        if (term instanceof Constant) {
            Constant constant = (Constant)term;
            return MessageFormat.format(" {0}", Op.str(constant.getValue()));
        }
        if (term instanceof Linear) {
            Linear linear = (Linear)term;
            StringWriter function = new StringWriter();
            Engine engine = linear.getEngine();
            List<Double> coefficients = linear.getCoefficients();
            for (int i = 0; i < coefficients.size() - 1; ++i) {
                function.append("(" + Op.str((Number)coefficients.get(i)) + " * " + engine.getInputVariable(i).getName() + ")");
                if (i + 1 >= coefficients.size()) continue;
                function.append(" + ");
            }
            if (coefficients.size() <= engine.getInputVariables().size()) return "FUNCTION " + function.toString();
            function.append("(" + Op.str((Number)coefficients.get(coefficients.size() - 1)) + ")");
            return "FUNCTION " + function.toString();
        }
        FuzzyLite.logger().log(Level.WARNING, "Discretizing {0}", term.getClass().getSimpleName());
        return Discrete.formatXY(Discrete.discretize(term, variable.getMinimum(), variable.getMaximum(), 100).getXY());
    }

    @Override
    public JflExporter clone() throws CloneNotSupportedException {
        return (JflExporter)super.clone();
    }
}

