/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.norm.t;

import com.fuzzylite.norm.TNorm;
import com.fuzzylite.term.Function;

public final class TNormFunction
extends TNorm {
    private Function function = new Function();

    public TNormFunction() {
        this("");
    }

    public TNormFunction(String formula) {
        this.function.getVariables().put("a", Double.NaN);
        this.function.getVariables().put("b", Double.NaN);
        if (!formula.isEmpty()) {
            this.function.load(formula);
        }
    }

    @Override
    public double compute(double a, double b) {
        this.function.getVariables().put("a", a);
        this.function.getVariables().put("b", b);
        return this.function.evaluate();
    }

    public Function function() {
        return this.function;
    }

    public void setFormula(String formula) {
        this.function.load(formula);
    }

    public String getFormula() {
        return this.function.getFormula();
    }

    @Override
    public TNormFunction clone() throws CloneNotSupportedException {
        TNormFunction result = (TNormFunction)super.clone();
        if (this.function != null) {
            result.function = this.function.clone();
            try {
                result.function.load(this.function.getFormula());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }
}

