/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.rule;

import com.fuzzylite.Engine;
import com.fuzzylite.FuzzyLite;
import com.fuzzylite.Op;
import com.fuzzylite.factory.FactoryManager;
import com.fuzzylite.factory.HedgeFactory;
import com.fuzzylite.hedge.Any;
import com.fuzzylite.hedge.Hedge;
import com.fuzzylite.norm.SNorm;
import com.fuzzylite.norm.TNorm;
import com.fuzzylite.rule.Expression;
import com.fuzzylite.rule.Operator;
import com.fuzzylite.rule.Proposition;
import com.fuzzylite.term.Function;
import com.fuzzylite.variable.OutputVariable;
import com.fuzzylite.variable.Variable;
import java.util.ArrayDeque;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class Antecedent {
    private String text = "";
    private Expression expression = null;

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public boolean isLoaded() {
        return this.expression != null;
    }

    public double activationDegree(TNorm conjunction, SNorm disjunction) {
        return this.activationDegree(conjunction, disjunction, this.expression);
    }

    public double activationDegree(TNorm conjunction, SNorm disjunction, Expression node) {
        if (!this.isLoaded()) {
            throw new RuntimeException(String.format("[antecedent error] antecedent <%s> is not loaded", this.text));
        }
        Expression.Type expressionType = node.type();
        if (expressionType == Expression.Type.Proposition) {
            Proposition proposition = (Proposition)node;
            if (!proposition.getVariable().isEnabled()) {
                return 0.0;
            }
            if (!proposition.getHedges().isEmpty()) {
                int lastIndex = proposition.getHedges().size();
                ListIterator<Hedge> rit = proposition.getHedges().listIterator(lastIndex);
                Hedge any = rit.previous();
                if (any instanceof Any) {
                    double result = any.hedge(Double.NaN);
                    while (rit.hasPrevious()) {
                        result = rit.previous().hedge(result);
                    }
                    return result;
                }
            }
            Variable variable = proposition.getVariable();
            double result = Double.NaN;
            Variable.Type variableType = variable.type();
            if (variableType == Variable.Type.Input) {
                result = proposition.getTerm().membership(variable.getValue());
            } else if (variableType == Variable.Type.Output) {
                result = ((OutputVariable)variable).fuzzyOutput().activationDegree(proposition.getTerm());
            }
            int lastIndex = proposition.getHedges().size();
            ListIterator<Hedge> reverseIterator = proposition.getHedges().listIterator(lastIndex);
            while (reverseIterator.hasPrevious()) {
                result = reverseIterator.previous().hedge(result);
            }
            return result;
        }
        if (expressionType == Expression.Type.Operator) {
            Operator operator = (Operator)node;
            if (operator.getLeft() == null || operator.getRight() == null) {
                throw new RuntimeException("[syntax error] left and right operators cannot be null");
            }
            if ("and".equals(operator.getName())) {
                if (conjunction == null) {
                    throw new RuntimeException(String.format("[conjunction error] the following rule requires a conjunction operator:\n%s", this.text));
                }
                return conjunction.compute(this.activationDegree(conjunction, disjunction, operator.getLeft()), this.activationDegree(conjunction, disjunction, operator.getRight()));
            }
            if ("or".equals(operator.getName())) {
                if (disjunction == null) {
                    throw new RuntimeException(String.format("[disjunction error] the following rule requires a disjunction operator:\n%s", this.text));
                }
                return disjunction.compute(this.activationDegree(conjunction, disjunction, operator.getLeft()), this.activationDegree(conjunction, disjunction, operator.getRight()));
            }
            throw new RuntimeException(String.format("[syntax error] operator <%s> not recognized", operator.getName()));
        }
        throw new RuntimeException("[expression error] unknown instance of Expression");
    }

    public void unload() {
        this.setExpression(null);
    }

    public void load(Engine engine) {
        this.load(this.getText(), engine);
    }

    public void load(String antecedent, Engine engine) {
        FuzzyLite.logger().log(Level.FINE, "Antecedent: {0}", antecedent);
        this.unload();
        this.setText(antecedent);
        if (antecedent.trim().isEmpty()) {
            throw new RuntimeException("[syntax error] antecedent is empty");
        }
        Function function = new Function();
        String postfix = function.toPostfix(antecedent);
        FuzzyLite.logger().log(Level.FINE, "Postfix {0}", postfix);
        boolean S_VARIABLE = true;
        int S_IS = 2;
        int S_HEDGE = 4;
        int S_TERM = 8;
        int S_AND_OR = 16;
        int state = 1;
        ArrayDeque<Expression> expressionStack = new ArrayDeque<Expression>();
        Proposition proposition = null;
        StringTokenizer tokenizer = new StringTokenizer(postfix);
        String token = "";
        while (tokenizer.hasMoreTokens()) {
            HedgeFactory hedgeFactory;
            token = tokenizer.nextToken();
            if (state & true) {
                Variable variable = null;
                if (engine.hasInputVariable(token)) {
                    variable = engine.getInputVariable(token);
                } else if (engine.hasOutputVariable(token)) {
                    variable = engine.getOutputVariable(token);
                }
                if (variable != null) {
                    proposition = new Proposition();
                    proposition.setVariable(variable);
                    expressionStack.push(proposition);
                    state = 2;
                    FuzzyLite.logger().log(Level.FINE, "Token <{0}> is variable", token);
                    continue;
                }
            }
            if ((state & 2) != 0 && "is".equals(token)) {
                state = 12;
                FuzzyLite.logger().log(Level.FINE, "Token <{0}> is keyword", token);
                continue;
            }
            if ((state & 4) != 0 && (hedgeFactory = FactoryManager.instance().hedge()).hasConstructor(token)) {
                Hedge hedge = (Hedge)hedgeFactory.constructObject(token);
                proposition.getHedges().add(hedge);
                state = hedge instanceof Any ? 17 : 12;
                FuzzyLite.logger().log(Level.FINE, "Token <{0}> is hedge", token);
                continue;
            }
            if ((state & 8) != 0 && proposition.getVariable().hasTerm(token)) {
                proposition.setTerm(proposition.getVariable().getTerm(token));
                state = 17;
                FuzzyLite.logger().log(Level.FINE, "Token <{0}> is term", token);
                continue;
            }
            if ((state & 0x10) != 0 && ("and".equals(token) || "or".equals(token))) {
                if (expressionStack.size() < 2) {
                    throw new RuntimeException(String.format("[syntax error] logical operator <%s> expects at least two operands, but found <%d>", token, expressionStack.size()));
                }
                Operator operator = new Operator();
                operator.setName(token);
                operator.setRight((Expression)expressionStack.pop());
                operator.setLeft((Expression)expressionStack.pop());
                expressionStack.push(operator);
                state = 17;
                FuzzyLite.logger().log(Level.FINE, "Subtree: ({0}) ({1})", new Object[]{operator.getLeft(), operator.getRight()});
                continue;
            }
            if ((state & 1) != 0 || (state & 0x10) != 0) {
                throw new RuntimeException(String.format("[syntax error] expected variable or logical operator, but found <%s>", token));
            }
            if ((state & 2) != 0) {
                throw new RuntimeException(String.format("[syntax error] expected keyword <%s>, but found <%s>", "is", token));
            }
            if ((state & 4) != 0 || (state & 8) != 0) {
                throw new RuntimeException(String.format("[syntax error] expected hedge or term, but found <%s>", token));
            }
            throw new RuntimeException(String.format("[syntax error] unexpected token <%s>", token));
        }
        if (!(state & true) && (state & 0x10) == 0) {
            if ((state & 2) != 0) {
                throw new RuntimeException(String.format("[syntax error] expected keyword <%s> after <%s>", "is", token));
            }
            if ((state & 4) != 0 || (state & 8) != 0) {
                throw new RuntimeException(String.format("[syntax error] expected hedge or term, but found <%s>", token));
            }
        }
        if (expressionStack.size() != 1) {
            LinkedList<String> errors = new LinkedList<String>();
            while (expressionStack.size() > 1) {
                Expression element = (Expression)expressionStack.pop();
                errors.add(element.toString());
            }
            throw new RuntimeException(String.format("[syntax error] unable to parse the following expressions: <%s>", Op.join(errors, " ")));
        }
        this.setExpression((Expression)expressionStack.pop());
    }

    public String toString() {
        return this.toInfix(this.expression);
    }

    public String toPrefix() {
        return this.toPrefix(this.expression);
    }

    public String toInfix() {
        return this.toInfix(this.expression);
    }

    public String toPostfix() {
        return this.toPostfix(this.expression);
    }

    public String toPrefix(Expression node) {
        if (!this.isLoaded()) {
            throw new RuntimeException(String.format("[antecedent error] antecedent <%s> is not loaded", this.text));
        }
        if (node instanceof Proposition) {
            return node.toString();
        }
        if (node instanceof Operator) {
            Operator operator = (Operator)node;
            return operator.toString() + " " + this.toPrefix(operator.getLeft()) + " " + this.toPrefix(operator.getRight()) + " ";
        }
        throw new RuntimeException(String.format("[expression error] unexpected class <%s>", node.getClass().getSimpleName()));
    }

    public String toInfix(Expression node) {
        if (!this.isLoaded()) {
            throw new RuntimeException(String.format("[antecedent error] antecedent <%s> is not loaded", this.text));
        }
        if (node instanceof Proposition) {
            return node.toString();
        }
        if (node instanceof Operator) {
            Operator operator = (Operator)node;
            return this.toInfix(operator.getLeft()) + " " + operator.toString() + " " + this.toInfix(operator.getRight()) + " ";
        }
        throw new RuntimeException(String.format("[expression error] unexpected class <%s>", node.getClass().getSimpleName()));
    }

    public String toPostfix(Expression node) {
        if (!this.isLoaded()) {
            throw new RuntimeException(String.format("[antecedent error] antecedent <%s> is not loaded", this.text));
        }
        if (node instanceof Proposition) {
            return node.toString();
        }
        if (node instanceof Operator) {
            Operator operator = (Operator)node;
            return this.toPostfix(operator.getLeft()) + " " + this.toPostfix(operator.getRight()) + " " + operator.toString() + " ";
        }
        throw new RuntimeException(String.format("[expression error] unexpected class <%s>", node.getClass().getSimpleName()));
    }
}

