/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.rule;

import com.fuzzylite.Engine;
import com.fuzzylite.FuzzyLite;
import com.fuzzylite.factory.FactoryManager;
import com.fuzzylite.factory.HedgeFactory;
import com.fuzzylite.hedge.Hedge;
import com.fuzzylite.norm.TNorm;
import com.fuzzylite.rule.Proposition;
import com.fuzzylite.term.Activated;
import com.fuzzylite.variable.OutputVariable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class Consequent {
    private String text = "";
    private List<Proposition> conclusions = new ArrayList<Proposition>();

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public List<Proposition> getConclusions() {
        return this.conclusions;
    }

    public void setConclusions(List<Proposition> conclusions) {
        this.conclusions = conclusions;
    }

    public void modify(double activationDegree, TNorm implication) {
        if (!this.isLoaded()) {
            throw new RuntimeException(String.format("[consequent error] consequent <%s> is not loaded", this.text));
        }
        for (Proposition proposition : this.conclusions) {
            if (!proposition.getVariable().isEnabled()) continue;
            if (!proposition.getHedges().isEmpty()) {
                int lastIndex = proposition.getHedges().size();
                ListIterator<Hedge> rit = proposition.getHedges().listIterator(lastIndex);
                while (rit.hasPrevious()) {
                    activationDegree = rit.previous().hedge(activationDegree);
                }
            }
            Activated term = new Activated(proposition.getTerm(), activationDegree, implication);
            ((OutputVariable)proposition.getVariable()).fuzzyOutput().getTerms().add(term);
            if (!FuzzyLite.isDebugging()) continue;
            FuzzyLite.logger().log(Level.FINE, "Aggregating {0}", term.toString());
        }
    }

    public boolean isLoaded() {
        return !this.conclusions.isEmpty();
    }

    public void unload() {
        this.conclusions.clear();
    }

    public void load(Engine engine) {
        this.load(this.getText(), engine);
    }

    public void load(String consequent, Engine engine) {
        this.unload();
        this.setText(consequent);
        if (consequent.trim().isEmpty()) {
            throw new RuntimeException("[syntax error] consequent is empty");
        }
        boolean S_VARIABLE = true;
        int S_IS = 2;
        int S_HEDGE = 4;
        int S_TERM = 8;
        int S_AND = 16;
        int S_WITH = 32;
        int state = 1;
        Proposition proposition = null;
        StringTokenizer tokenizer = new StringTokenizer(consequent);
        String token = "";
        try {
            while (tokenizer.hasMoreTokens()) {
                HedgeFactory hedgeFactory;
                token = tokenizer.nextToken();
                if ((state & 1) != 0 && engine.hasOutputVariable(token)) {
                    proposition = new Proposition();
                    proposition.setVariable(engine.getOutputVariable(token));
                    this.getConclusions().add(proposition);
                    state = 2;
                    continue;
                }
                if ((state & 2) != 0 && "is".equals(token)) {
                    state = 12;
                    continue;
                }
                if ((state & 4) != 0 && (hedgeFactory = FactoryManager.instance().hedge()).hasConstructor(token)) {
                    Hedge hedge = (Hedge)hedgeFactory.constructObject(token);
                    proposition.getHedges().add(hedge);
                    state = 12;
                    continue;
                }
                if ((state & 8) != 0 && proposition.getVariable().hasTerm(token)) {
                    proposition.setTerm(proposition.getVariable().getTerm(token));
                    state = 48;
                    continue;
                }
                if ((state & 0x10) != 0 && "and".equals(token)) {
                    state = 1;
                    continue;
                }
                if ((state & 1) != 0) {
                    throw new RuntimeException(String.format("[syntax error] consequent expected output variable, but found <%s>", token));
                }
                if ((state & 2) != 0) {
                    throw new RuntimeException(String.format("[syntax error] consequent expected keyword <%s>, but found <%s>", "is", token));
                }
                if ((state & 4) != 0 || (state & 8) != 0) {
                    throw new RuntimeException(String.format("[syntax error] consequent expected hedge or term, but found <%s>", token));
                }
                if ((state & 0x10) != 0 || (state & 0x20) != 0) {
                    throw new RuntimeException(String.format("[syntax error] consequent expected operator <%s> or keyword <%s>, sbut found <%s>", "and", "with", token));
                }
                throw new RuntimeException(String.format("[syntax error] unexpected token <%s>", token));
            }
            if ((state & 0x10) == 0 && (state & 0x20) == 0) {
                if ((state & 1) != 0) {
                    throw new RuntimeException(String.format("[syntax error] consequent expected output variable after <%s>", token));
                }
                if ((state & 2) != 0) {
                    throw new RuntimeException(String.format("[syntax error] consequent expected keyword <%s> after <%s>", "is", token));
                }
                if ((state & 4) != 0 || (state & 8) != 0) {
                    throw new RuntimeException(String.format("[syntax error] consequent expected hedge or term after <%s>", token));
                }
            }
        }
        catch (RuntimeException ex) {
            this.unload();
            throw ex;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<Proposition> it = this.conclusions.iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString());
            if (!it.hasNext()) continue;
            sb.append(String.format(" %s ", "and"));
        }
        return sb.toString();
    }
}

