/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.rule;

import com.fuzzylite.hedge.Hedge;
import com.fuzzylite.rule.Expression;
import com.fuzzylite.term.Term;
import com.fuzzylite.variable.Variable;
import java.util.ArrayList;
import java.util.List;

public final class Proposition
extends Expression {
    private Variable variable;
    private List<Hedge> hedges;
    private Term term;

    public Proposition() {
        this(null, null);
    }

    public Proposition(Variable variable, Term term) {
        this(variable, new ArrayList<Hedge>(), term);
    }

    public Proposition(Variable variable, List<Hedge> hedges, Term term) {
        this.variable = variable;
        this.hedges = hedges;
        this.term = term;
    }

    public Variable getVariable() {
        return this.variable;
    }

    public void setVariable(Variable variable) {
        this.variable = variable;
    }

    public List<Hedge> getHedges() {
        return this.hedges;
    }

    public void setHedges(List<Hedge> hedges) {
        this.hedges = hedges;
    }

    public Term getTerm() {
        return this.term;
    }

    public void setTerm(Term term) {
        this.term = term;
    }

    @Override
    public Expression.Type type() {
        return Expression.Type.Proposition;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.variable.getName()).append(" ").append("is").append(" ");
        for (Hedge hedge : this.hedges) {
            result.append(hedge.getName()).append(" ");
        }
        if (this.term != null) {
            result.append(this.term.getName());
        }
        return result.toString();
    }
}

