/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.rule;

import com.fuzzylite.Engine;
import com.fuzzylite.FuzzyLite;
import com.fuzzylite.Op;
import com.fuzzylite.imex.FllExporter;
import com.fuzzylite.norm.SNorm;
import com.fuzzylite.norm.TNorm;
import com.fuzzylite.rule.Antecedent;
import com.fuzzylite.rule.Consequent;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class Rule
implements Op.Cloneable {
    public static final String FL_IF = "if";
    public static final String FL_IS = "is";
    public static final String FL_THEN = "then";
    public static final String FL_AND = "and";
    public static final String FL_OR = "or";
    public static final String FL_WITH = "with";
    private boolean enabled = true;
    private String text;
    private double weight;
    private double activationDegree;
    private boolean triggered;
    private Antecedent antecedent;
    private Consequent consequent;

    public Rule() {
        this("");
    }

    public Rule(String text) {
        this(text, 1.0);
    }

    public Rule(String text, double weight) {
        this.text = text;
        this.weight = weight;
        this.activationDegree = 0.0;
        this.triggered = false;
        this.antecedent = new Antecedent();
        this.consequent = new Consequent();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public Antecedent getAntecedent() {
        return this.antecedent;
    }

    public void setAntecedent(Antecedent antecedent) {
        this.antecedent = antecedent;
    }

    public Consequent getConsequent() {
        return this.consequent;
    }

    public void setConsequent(Consequent consequent) {
        this.consequent = consequent;
    }

    public double getActivationDegree() {
        return this.activationDegree;
    }

    public void setActivationDegree(double activationDegree) {
        this.activationDegree = activationDegree;
    }

    public void deactivate() {
        this.activationDegree = 0.0;
        this.triggered = false;
    }

    public double activateWith(TNorm conjunction, SNorm disjunction) {
        if (!this.isLoaded()) {
            throw new RuntimeException(String.format("[rule error] the following rule is not loaded: %s", this.text));
        }
        this.activationDegree = this.weight * this.antecedent.activationDegree(conjunction, disjunction);
        return this.activationDegree;
    }

    public void trigger(TNorm implication) {
        if (!this.isLoaded()) {
            throw new RuntimeException(String.format("[rule error] the following rule is not loaded: %s", this.text));
        }
        if (this.enabled && Op.isGt(this.activationDegree, 0.0)) {
            if (FuzzyLite.isDebugging()) {
                FuzzyLite.logger().log(Level.FINE, "[firing with {0}] {1}", new String[]{Op.str(this.activationDegree), this.toString()});
            }
            this.consequent.modify(this.activationDegree, implication);
            this.triggered = true;
        }
    }

    public boolean isTriggered() {
        return this.triggered;
    }

    public boolean isLoaded() {
        return this.antecedent != null && this.consequent != null && this.antecedent.isLoaded() && this.consequent.isLoaded();
    }

    public void unload() {
        this.deactivate();
        if (this.getAntecedent() != null) {
            this.getAntecedent().unload();
        }
        if (this.getConsequent() != null) {
            this.getConsequent().unload();
        }
    }

    public void load(Engine engine) {
        this.load(this.getText(), engine);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(String rule, Engine engine) {
        this.deactivate();
        this.setEnabled(true);
        this.setText(rule);
        StringTokenizer tokenizer = new StringTokenizer(rule);
        StringBuilder strAntecedent = new StringBuilder();
        StringBuilder strConsequent = new StringBuilder();
        double ruleWeight = 1.0;
        boolean S_NONE = false;
        boolean S_IF = true;
        int S_THEN = 2;
        int S_WITH = 3;
        int S_END = 4;
        byte state = 0;
        try {
            block11: while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                int commentIndex = token.indexOf(35);
                if (commentIndex >= 0) {
                    token = token.substring(0, commentIndex);
                }
                switch (state) {
                    case 0: {
                        if (!FL_IF.equals(token)) {
                            throw new RuntimeException(String.format("[syntax error] expected keyword <%s>, but found <%s> in rule: %s", FL_IF, token, rule));
                        }
                        state = 1;
                        continue block11;
                    }
                    case 1: {
                        if (FL_THEN.equals(token)) {
                            state = 2;
                            continue block11;
                        }
                        strAntecedent.append(token).append(" ");
                        continue block11;
                    }
                    case 2: {
                        if (FL_WITH.equals(token)) {
                            state = 3;
                            continue block11;
                        }
                        strConsequent.append(token).append(" ");
                        continue block11;
                    }
                    case 3: {
                        ruleWeight = Op.toDouble(token);
                        state = 4;
                        continue block11;
                    }
                    case 4: {
                        throw new RuntimeException(String.format("[syntax error] unexpected token <%s> at the end of rule", token));
                    }
                }
                throw new RuntimeException(String.format("[syntax error] unexpected state <%s>", state));
            }
            if (state == 0) {
                throw new RuntimeException(String.format("[syntax error] %s rule: %s", rule.isEmpty() ? "empty" : "ignored", rule));
            }
            if (state == 1) {
                throw new RuntimeException(String.format("[syntax error] keyword <%s> not found in rule: %s", FL_THEN, rule));
            }
            if (state == 3) {
                throw new RuntimeException(String.format("[syntax error] expected a numeric value as the weight of the rule: %s", rule));
            }
            this.getAntecedent().load(strAntecedent.toString(), engine);
            this.getConsequent().load(strConsequent.toString(), engine);
            this.setWeight(ruleWeight);
            return;
        }
        catch (RuntimeException ex) {
            this.unload();
            throw ex;
        }
    }

    public String toString() {
        return new FllExporter().toString(this);
    }

    public static Rule parse(String rule, Engine engine) {
        Rule result = new Rule();
        result.load(rule, engine);
        return result;
    }

    @Override
    public Rule clone() throws CloneNotSupportedException {
        Rule result = (Rule)super.clone();
        result.antecedent = new Antecedent();
        result.consequent = new Consequent();
        return result;
    }
}

