/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.rule;

import com.fuzzylite.Engine;
import com.fuzzylite.Op;
import com.fuzzylite.activation.Activation;
import com.fuzzylite.activation.General;
import com.fuzzylite.imex.FllExporter;
import com.fuzzylite.norm.SNorm;
import com.fuzzylite.norm.TNorm;
import com.fuzzylite.rule.Rule;
import java.util.ArrayList;
import java.util.List;

public class RuleBlock
implements Op.Cloneable {
    private boolean enabled = true;
    private String name;
    private String description;
    private TNorm conjunction;
    private SNorm disjunction;
    private TNorm implication;
    private Activation activation;
    private List<Rule> rules;

    public RuleBlock() {
        this("");
    }

    public RuleBlock(String name) {
        this.name = name;
        this.description = "";
        this.rules = new ArrayList<Rule>();
    }

    public void activate() {
        if (this.activation == null) {
            this.activation = new General();
        }
        this.activation.activate(this);
    }

    public void unloadRules() {
        for (Rule rule : this.rules) {
            rule.unload();
        }
    }

    public void loadRules(Engine engine) {
        ArrayList<String> exceptions = new ArrayList<String>();
        for (Rule rule : this.rules) {
            if (rule.isLoaded()) {
                rule.unload();
            }
            try {
                rule.load(engine);
            }
            catch (Exception ex) {
                exceptions.add(String.format("[%s]: %s", rule.getText(), ex.toString()));
            }
        }
        if (!exceptions.isEmpty()) {
            throw new RuntimeException("[ruleblock error] the following rules could not be loaded:\n" + Op.join(exceptions, "\n"));
        }
    }

    public void reloadRules(Engine engine) {
        this.unloadRules();
        this.loadRules(engine);
    }

    public String toString() {
        return new FllExporter().toString(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TNorm getConjunction() {
        return this.conjunction;
    }

    public void setConjunction(TNorm conjunction) {
        this.conjunction = conjunction;
    }

    public SNorm getDisjunction() {
        return this.disjunction;
    }

    public void setDisjunction(SNorm disjunction) {
        this.disjunction = disjunction;
    }

    public TNorm getImplication() {
        return this.implication;
    }

    public void setImplication(TNorm implication) {
        this.implication = implication;
    }

    public Activation getActivation() {
        return this.activation;
    }

    public void setActivation(Activation activation) {
        this.activation = activation;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public RuleBlock clone() throws CloneNotSupportedException {
        RuleBlock result = (RuleBlock)super.clone();
        if (this.conjunction != null) {
            result.conjunction = this.conjunction.clone();
        }
        if (this.disjunction != null) {
            result.disjunction = this.disjunction.clone();
        }
        if (this.implication != null) {
            result.implication = this.implication.clone();
        }
        result.rules = new ArrayList<Rule>(this.rules.size());
        for (Rule rule : this.rules) {
            result.addRule(rule.clone());
        }
        return result;
    }

    public Rule getRule(int index) {
        return this.rules.get(index);
    }

    public void addRule(Rule rule) {
        this.rules.add(rule);
    }

    public Rule removeRule(int index) {
        return this.rules.remove(index);
    }

    public int numberOfRules() {
        return this.rules.size();
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public void setRules(List<Rule> rules) {
        this.rules = rules;
    }
}

