/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.term;

import com.fuzzylite.Op;
import com.fuzzylite.imex.FllExporter;
import com.fuzzylite.norm.TNorm;
import com.fuzzylite.term.Term;

public class Activated
extends Term {
    private Term term;
    private double degree;
    private TNorm implication;

    public Activated() {
        this(null, 1.0, null);
    }

    public Activated(Term term, double degree, TNorm implication) {
        this.term = term;
        this.degree = degree;
        this.implication = implication;
    }

    @Override
    public double membership(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (this.implication == null) {
            throw new RuntimeException(String.format("[implication error] implication operator needed to activate %s", this.getTerm().toString()));
        }
        return this.implication.compute(this.term.membership(x), this.degree);
    }

    @Override
    public String parameters() {
        FllExporter exporter = new FllExporter();
        String result = String.format("%s %s %s", Op.str(this.degree), exporter.toString(this.implication), exporter.toString(this.term));
        return result;
    }

    @Override
    public String toString() {
        return String.format("%s(%s,%s)", new FllExporter().toString(this.implication), Op.str(this.degree), this.term.getName());
    }

    @Override
    public void configure(String parameters) {
    }

    public Term getTerm() {
        return this.term;
    }

    public void setTerm(Term term) {
        this.term = term;
    }

    public double getDegree() {
        return this.degree;
    }

    public void setDegree(double degree) {
        this.degree = degree;
    }

    public TNorm getImplication() {
        return this.implication;
    }

    public void setImplication(TNorm implication) {
        this.implication = implication;
    }

    @Override
    public Activated clone() throws CloneNotSupportedException {
        return (Activated)super.clone();
    }
}

