/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.term;

import com.fuzzylite.Op;
import com.fuzzylite.imex.FllExporter;
import com.fuzzylite.norm.SNorm;
import com.fuzzylite.term.Activated;
import com.fuzzylite.term.Term;
import java.util.ArrayList;
import java.util.List;

public class Aggregated
extends Term {
    private List<Activated> terms = new ArrayList<Activated>();
    private double minimum;
    private double maximum;
    private SNorm aggregation;

    public Aggregated() {
        this("");
    }

    public Aggregated(String name) {
        this(name, Double.NaN, Double.NaN, null);
    }

    public Aggregated(String name, double minimum, double maximum) {
        this(name, minimum, maximum, null);
    }

    public Aggregated(String name, double minimum, double maximum, SNorm aggregation) {
        this.name = name;
        this.minimum = minimum;
        this.maximum = maximum;
        this.aggregation = aggregation;
    }

    @Override
    public String parameters() {
        FllExporter exporter = new FllExporter();
        StringBuilder result = new StringBuilder();
        result.append(String.format("%s %s %s", Op.str(this.minimum), Op.str(this.maximum), exporter.toString(this.aggregation)));
        for (Term term : this.terms) {
            result.append(" ").append(exporter.toString(term));
        }
        return result.toString();
    }

    @Override
    public void configure(String parameters) {
    }

    @Override
    public double membership(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        double mu = 0.0;
        for (Activated term : this.terms) {
            mu = this.aggregation.compute(mu, term.membership(x));
        }
        return mu;
    }

    public double activationDegree(Term forTerm) {
        double result = 0.0;
        for (Activated activatedTerm : this.terms) {
            if (activatedTerm.getTerm() != forTerm) continue;
            if (this.aggregation != null) {
                result = this.aggregation.compute(result, activatedTerm.getDegree());
                continue;
            }
            result += activatedTerm.getDegree();
        }
        return result;
    }

    public Activated highestActivatedTerm() {
        Activated maximumTerm = null;
        double maximumActivation = Double.POSITIVE_INFINITY;
        for (Activated activated : this.terms) {
            if (!Op.isGt(activated.getDegree(), maximumActivation)) continue;
            maximumActivation = activated.getDegree();
            maximumTerm = activated;
        }
        return maximumTerm;
    }

    @Override
    public String toString() {
        return String.format("%s: %s %s[%s]", this.name, this.getClass().getSimpleName(), new FllExporter().toString(this.aggregation), Op.join(this.terms, ","));
    }

    public void clear() {
        this.terms.clear();
    }

    public List<Activated> getTerms() {
        return this.terms;
    }

    public void setTerms(List<Activated> terms) {
        this.terms = terms;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public void setMinimum(double minimum) {
        this.minimum = minimum;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public void setMaximum(double maximum) {
        this.maximum = maximum;
    }

    public void setRange(double minimum, double maximum) {
        this.setMinimum(minimum);
        this.setMaximum(maximum);
    }

    public double range() {
        return this.getMaximum() - this.getMinimum();
    }

    public SNorm getAggregation() {
        return this.aggregation;
    }

    public void setAggregation(SNorm aggregation) {
        this.aggregation = aggregation;
    }

    @Override
    public Aggregated clone() throws CloneNotSupportedException {
        Aggregated result = (Aggregated)super.clone();
        if (this.aggregation != null) {
            result.aggregation = this.aggregation.clone();
        }
        result.terms = new ArrayList<Activated>(this.terms.size());
        for (Activated term : this.terms) {
            result.terms.add(term.clone());
        }
        return result;
    }
}

