/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.term;

import com.fuzzylite.Op;
import com.fuzzylite.term.Term;
import java.util.Iterator;
import java.util.List;

public class Bell
extends Term {
    private double center;
    private double width;
    private double slope;

    public Bell() {
        this("");
    }

    public Bell(String name) {
        this(name, Double.NaN, Double.NaN, Double.NaN);
    }

    public Bell(String name, double center, double width, double slope) {
        this(name, center, width, slope, 1.0);
    }

    public Bell(String name, double center, double width, double slope, double height) {
        super(name, height);
        this.center = center;
        this.width = width;
        this.slope = slope;
    }

    @Override
    public String parameters() {
        return Op.join(" ", this.center, this.width, this.slope) + (!Op.isEq(this.height, 1.0) ? " " + Op.str(this.height) : "");
    }

    @Override
    public void configure(String parameters) {
        if (parameters.isEmpty()) {
            return;
        }
        List<String> values = Op.split(parameters, " ");
        int required = 3;
        if (values.size() < required) {
            throw new RuntimeException(String.format("[configuration error] term <%s> requires <%d> parameters", this.getClass().getSimpleName(), required));
        }
        Iterator<String> it = values.iterator();
        this.setCenter(Op.toDouble(it.next()));
        this.setWidth(Op.toDouble(it.next()));
        this.setSlope(Op.toDouble(it.next()));
        if (values.size() > required) {
            this.setHeight(Op.toDouble(it.next()));
        }
    }

    @Override
    public double membership(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        return this.height * 1.0 / (1.0 + Math.pow(Math.abs((x - this.center) / this.width), 2.0 * this.slope));
    }

    public double getCenter() {
        return this.center;
    }

    public void setCenter(double center) {
        this.center = center;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getSlope() {
        return this.slope;
    }

    public void setSlope(double slope) {
        this.slope = slope;
    }

    @Override
    public Bell clone() throws CloneNotSupportedException {
        return (Bell)super.clone();
    }
}

