/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.term;

import com.fuzzylite.Op;
import com.fuzzylite.term.Term;
import java.util.Iterator;
import java.util.List;

public class Binary
extends Term {
    private double start;
    private double direction;

    public Binary() {
        this("");
    }

    public Binary(String name) {
        this(name, Double.NaN, Double.NaN);
    }

    public Binary(String name, double start, double direction) {
        this(name, start, direction, 1.0);
    }

    public Binary(String name, double start, double direction, double height) {
        super(name, height);
        this.start = start;
        this.direction = direction;
    }

    @Override
    public String parameters() {
        return Op.join(" ", this.start, this.direction) + (!Op.isEq(this.height, 1.0) ? " " + Op.str(this.height) : "");
    }

    @Override
    public void configure(String parameters) {
        if (parameters.isEmpty()) {
            return;
        }
        List<String> values = Op.split(parameters, " ");
        int required = 2;
        if (values.size() < required) {
            throw new RuntimeException(String.format("[configuration error] term <%s> requires <%d> parameters", this.getClass().getSimpleName(), required));
        }
        Iterator<String> it = values.iterator();
        this.setStart(Op.toDouble(it.next()));
        this.setDirection(Op.toDouble(it.next()));
        if (values.size() > required) {
            this.setHeight(Op.toDouble(it.next()));
        }
    }

    @Override
    public double membership(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (this.direction > this.start && Op.isGE(x, this.start)) {
            return this.height * 1.0;
        }
        if (this.direction < this.start && Op.isLE(x, this.start)) {
            return this.height * 1.0;
        }
        return this.height * 0.0;
    }

    public double getStart() {
        return this.start;
    }

    public void setStart(double start) {
        this.start = start;
    }

    public double getDirection() {
        return this.direction;
    }

    public void setDirection(double direction) {
        this.direction = direction;
    }

    public Direction direction() {
        if (this.direction > this.start) {
            return Direction.Positive;
        }
        if (this.direction < this.start) {
            return Direction.Negative;
        }
        return Direction.Undefined;
    }

    @Override
    public Binary clone() throws CloneNotSupportedException {
        return (Binary)super.clone();
    }

    public static enum Direction {
        Positive,
        Undefined,
        Negative;

    }
}

