/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.term;

import com.fuzzylite.Op;
import com.fuzzylite.term.Term;
import java.util.Iterator;
import java.util.List;

public class Concave
extends Term {
    private double inflection;
    private double end;

    public Concave() {
        this("");
    }

    public Concave(String name) {
        this(name, Double.NaN, Double.NaN);
    }

    public Concave(String name, double inflection, double end) {
        this(name, inflection, end, 1.0);
    }

    public Concave(String name, double inflection, double end, double height) {
        super(name, height);
        this.inflection = inflection;
        this.end = end;
    }

    @Override
    public String parameters() {
        return Op.join(" ", this.inflection, this.end) + (!Op.isEq(this.height, 1.0) ? " " + Op.str(this.height) : "");
    }

    @Override
    public void configure(String parameters) {
        if (parameters.isEmpty()) {
            return;
        }
        List<String> values = Op.split(parameters, " ");
        int required = 2;
        if (values.size() < required) {
            throw new RuntimeException(String.format("[configuration error] term <%s> requires <%d> parameters", this.getClass().getSimpleName(), required));
        }
        Iterator<String> it = values.iterator();
        this.setInflection(Op.toDouble(it.next()));
        this.setEnd(Op.toDouble(it.next()));
        if (values.size() > required) {
            this.setHeight(Op.toDouble(it.next()));
        }
    }

    @Override
    public double membership(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (Op.isLE(this.inflection, this.end)) {
            if (Op.isLt(x, this.end)) {
                return this.height * (this.end - this.inflection) / (2.0 * this.end - this.inflection - x);
            }
        } else if (Op.isGt(x, this.end)) {
            return this.height * (this.inflection - this.end) / (this.inflection - 2.0 * this.end + x);
        }
        return this.height * 1.0;
    }

    @Override
    public double tsukamoto(double activationDegree, double minimum, double maximum) {
        double i = this.getInflection();
        double e = this.getEnd();
        return (i - e) / this.membership(activationDegree) + 2.0 * e - i;
    }

    @Override
    public boolean isMonotonic() {
        return true;
    }

    public double getInflection() {
        return this.inflection;
    }

    public void setInflection(double inflection) {
        this.inflection = inflection;
    }

    public double getEnd() {
        return this.end;
    }

    public void setEnd(double end) {
        this.end = end;
    }

    @Override
    public Concave clone() throws CloneNotSupportedException {
        return (Concave)super.clone();
    }
}

