/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.term;

import com.fuzzylite.Op;
import com.fuzzylite.defuzzifier.IntegralDefuzzifier;
import com.fuzzylite.term.Term;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class Discrete
extends Term
implements List<Pair> {
    private List<Pair> xy;
    public static final Ascendantly ASCENDANTLY = new Ascendantly();

    public Discrete() {
        this("");
    }

    public Discrete(String name) {
        this(name, new ArrayList<Pair>());
    }

    public Discrete(String name, List<Pair> xy) {
        this(name, xy, 1.0);
    }

    public Discrete(String name, List<Pair> xy, double height) {
        super(name, height);
        this.xy = xy;
    }

    @Override
    public String parameters() {
        StringBuilder result = new StringBuilder();
        Iterator<Pair> it = this.xy.iterator();
        while (it.hasNext()) {
            Pair pair = it.next();
            result.append(String.format("%s %s", Op.str(pair.getX()), Op.str(pair.getY())));
            if (!it.hasNext()) continue;
            result.append(" ");
        }
        if (!Op.isEq(this.height, 1.0)) {
            result.append(String.format(" %s", Op.str(this.height)));
        }
        return result.toString();
    }

    @Override
    public void configure(String parameters) {
        if (parameters.isEmpty()) {
            return;
        }
        LinkedList<Double> values = new LinkedList<Double>();
        List<String> strValues = Op.split(parameters, " ");
        for (String strValue : strValues) {
            values.add(Op.toDouble(strValue));
        }
        if (values.size() % 2 == 0) {
            this.setHeight(1.0);
        } else {
            this.setHeight((Double)values.removeLast());
        }
        this.setXY(Discrete.toPairs(values));
    }

    public static Discrete create(String name, double ... xy) {
        int mod2 = xy.length % 2;
        ArrayList<Pair> xyValues = new ArrayList<Pair>(xy.length / 2);
        for (int i = 0; i < xy.length - mod2; i += 2) {
            xyValues.add(new Pair(xy[i], xy[i + 1]));
        }
        Discrete result = new Discrete(name, xyValues);
        if (mod2 != 0) {
            result.setHeight(xy[xy.length - 1]);
        }
        return new Discrete(name, xyValues);
    }

    public static Discrete discretize(Term term, double start, double end) {
        return Discrete.discretize(term, start, end, IntegralDefuzzifier.getDefaultResolution());
    }

    public static Discrete discretize(Term term, double start, double end, int resolution) {
        return Discrete.discretize(term, start, end, resolution, true);
    }

    public static Discrete discretize(Term term, double start, double end, int resolution, boolean boundedMembershipFunction) {
        Discrete result = new Discrete(term.getName());
        double dx = (end - start) / (double)resolution;
        for (int i = 0; i <= resolution; ++i) {
            double x = start + (double)i * dx;
            double y = term.membership(x);
            if (boundedMembershipFunction) {
                y = Op.bound(y, 0.0, 1.0);
            }
            result.add(new Pair(x, y));
        }
        return result;
    }

    public void sort() {
        Collections.sort(this, ASCENDANTLY);
    }

    public static void sort(List<Pair> pairs) {
        Collections.sort(pairs, ASCENDANTLY);
    }

    @Override
    public double membership(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (this.xy.isEmpty()) {
            throw new RuntimeException("[discrete error] term is empty");
        }
        Pair first = this.xy.get(0);
        Pair last = this.xy.get(this.xy.size() - 1);
        if (Op.isLE(x, first.getX())) {
            return this.height * first.getY();
        }
        if (Op.isGE(x, last.getX())) {
            return this.height * last.getY();
        }
        Pair value = new Pair(x, Double.NaN);
        int upper = Collections.binarySearch(this.xy, value, ASCENDANTLY);
        if (upper >= 0) {
            return this.height * this.xy.get((int)upper).y;
        }
        upper = Math.abs(upper + 1);
        int lower = upper - 1;
        return this.height * Op.scale(x, this.xy.get(lower).getX(), this.xy.get(upper).getX(), this.xy.get(lower).getY(), this.xy.get(upper).getY());
    }

    public List<Pair> getXY() {
        return this.xy;
    }

    public void setXY(List<Pair> pairs) {
        this.xy = pairs;
    }

    public List<Double> x() {
        ArrayList<Double> result = new ArrayList<Double>(this.xy.size());
        for (Pair pair : this.xy) {
            result.add(pair.x);
        }
        return result;
    }

    public double x(int index) {
        return this.xy.get((int)index).x;
    }

    public List<Double> y() {
        ArrayList<Double> result = new ArrayList<Double>(this.xy.size());
        for (Pair pair : this.xy) {
            result.add(pair.y);
        }
        return result;
    }

    public double y(int index) {
        return this.xy.get((int)index).y;
    }

    @Override
    public Discrete clone() throws CloneNotSupportedException {
        Discrete result = (Discrete)super.clone();
        ArrayList<Pair> xyClone = new ArrayList<Pair>(this.xy.size());
        for (Pair p : this.xy) {
            xyClone.add(p.clone());
        }
        result.xy = xyClone;
        return result;
    }

    public static List<Double> toList(List<Pair> xyValues) {
        ArrayList<Double> result = new ArrayList<Double>(xyValues.size() * 2);
        for (Pair pair : xyValues) {
            result.add(pair.getX());
            result.add(pair.getY());
        }
        return result;
    }

    public static List<Pair> toPairs(List<Double> xyValues) {
        if (xyValues.size() % 2 != 0) {
            throw new RuntimeException(String.format("[discrete error] missing value in set of pairs (|xy|=%d)", xyValues.size()));
        }
        ArrayList<Pair> result = new ArrayList<Pair>((xyValues.size() + 1) / 2);
        Iterator<Double> it = xyValues.iterator();
        while (it.hasNext()) {
            result.add(new Pair(it.next(), it.next()));
        }
        return result;
    }

    public static List<Pair> toPairs(List<Double> xyValues, double missingValue) {
        ArrayList<Pair> result = new ArrayList<Pair>((xyValues.size() + 1) / 2);
        Iterator<Double> it = xyValues.iterator();
        while (it.hasNext()) {
            result.add(new Pair(it.next(), it.hasNext() ? it.next() : missingValue));
        }
        return result;
    }

    public static String formatXY(List<Pair> xy) {
        return Discrete.formatXY(xy, "(", ",", ")", " ");
    }

    public static String formatXY(List<Pair> xy, String prefix, String innerSeparator, String suffix, String outerSeparator) {
        StringBuilder result = new StringBuilder();
        Iterator<Pair> it = xy.iterator();
        while (it.hasNext()) {
            Pair pair = it.next();
            result.append(prefix).append(Op.str(pair.getX())).append(innerSeparator).append(Op.str(pair.getY())).append(suffix);
            if (!it.hasNext()) continue;
            result.append(outerSeparator);
        }
        return result.toString();
    }

    @Override
    public int size() {
        return this.xy.size();
    }

    @Override
    public boolean isEmpty() {
        return this.xy.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.xy.contains(o);
    }

    @Override
    public Iterator<Pair> iterator() {
        return this.xy.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.xy.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.xy.toArray(a);
    }

    @Override
    public boolean add(Pair e) {
        return this.xy.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.xy.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.xy.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Pair> c) {
        return this.xy.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Pair> c) {
        return this.xy.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.xy.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.xy.removeAll(c);
    }

    @Override
    public void clear() {
        this.xy.clear();
    }

    @Override
    public Pair get(int index) {
        return this.xy.get(index);
    }

    @Override
    public Pair set(int index, Pair element) {
        return this.xy.set(index, element);
    }

    @Override
    public void add(int index, Pair element) {
        this.xy.add(index, element);
    }

    @Override
    public Pair remove(int index) {
        return this.xy.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.xy.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.xy.lastIndexOf(o);
    }

    @Override
    public ListIterator<Pair> listIterator() {
        return this.xy.listIterator();
    }

    @Override
    public ListIterator<Pair> listIterator(int index) {
        return this.xy.listIterator(index);
    }

    @Override
    public List<Pair> subList(int fromIndex, int toIndex) {
        return this.xy.subList(fromIndex, toIndex);
    }

    public static class Ascendantly
    implements Comparator<Pair> {
        @Override
        public int compare(Pair o1, Pair o2) {
            if (o1.x < o2.x) {
                return -1;
            }
            if (o1.x > o2.x) {
                return 1;
            }
            return 0;
        }
    }

    public static class Pair
    implements Op.Cloneable {
        public double x;
        public double y;

        public Pair() {
            this(Double.NaN, Double.NaN);
        }

        public Pair(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public double getX() {
            return this.x;
        }

        public void setX(double x) {
            this.x = x;
        }

        public double getY() {
            return this.y;
        }

        public void setY(double y) {
            this.y = y;
        }

        @Override
        public Pair clone() throws CloneNotSupportedException {
            return (Pair)super.clone();
        }

        public String toString() {
            return "(" + Op.str(this.x) + "," + Op.str(this.y) + ")";
        }
    }
}

