/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.term;

import com.fuzzylite.Engine;
import com.fuzzylite.FuzzyLite;
import com.fuzzylite.Op;
import com.fuzzylite.factory.FactoryManager;
import com.fuzzylite.factory.FunctionFactory;
import com.fuzzylite.term.Term;
import com.fuzzylite.variable.InputVariable;
import com.fuzzylite.variable.OutputVariable;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class Function
extends Term {
    private Node root;
    private String formula;
    private Engine engine;
    private Map<String, Double> variables;

    public Function() {
        this("");
    }

    public Function(String name) {
        this(name, "", null);
    }

    public Function(String name, String formula, Engine engine) {
        this.name = name;
        this.root = null;
        this.formula = formula;
        this.engine = engine;
        this.variables = new HashMap<String, Double>();
    }

    @Override
    public String parameters() {
        return this.formula;
    }

    @Override
    public void configure(String parameters) {
        if (parameters.isEmpty()) {
            return;
        }
        this.load(parameters);
    }

    @Override
    public double membership(double x) {
        if (this.root == null) {
            throw new RuntimeException(String.format("[function error] function <%s> not loaded.", this.formula));
        }
        if (this.engine != null) {
            for (InputVariable inputVariable : this.engine.getInputVariables()) {
                this.variables.put(inputVariable.getName(), inputVariable.getValue());
            }
            for (OutputVariable outputVariable : this.engine.getOutputVariables()) {
                this.variables.put(outputVariable.getName(), outputVariable.getValue());
            }
        }
        this.variables.put("x", x);
        return this.evaluate(this.variables);
    }

    public double evaluate() {
        return this.evaluate(this.variables);
    }

    public double evaluate(Map<String, Double> localVariables) {
        if (this.root == null) {
            throw new RuntimeException("[function error] evaluation failed because function is not loaded");
        }
        return this.root.evaluate(localVariables);
    }

    public static Function create(String name, String formula, Engine engine) {
        Function result = new Function(name);
        try {
            result.load(formula, engine);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }

    @Override
    public Function clone() throws CloneNotSupportedException {
        Function result = (Function)super.clone();
        if (this.root != null) {
            result.root = this.root.clone();
        }
        result.variables = new HashMap<String, Double>(this.variables);
        return result;
    }

    @Override
    public void updateReference(Engine engine) {
        this.setEngine(engine);
        this.load();
    }

    public boolean isLoaded() {
        return this.root != null;
    }

    public void unload() {
        this.root = null;
        this.variables.clear();
    }

    public void load() {
        this.load(this.formula, this.engine);
    }

    public void load(String formula) {
        this.load(formula, this.engine);
    }

    public void load(String formula, Engine engine) {
        this.root = this.parse(formula);
        this.formula = formula;
        this.engine = engine;
    }

    public String toPostfix(String formula) {
        FunctionFactory factory = FactoryManager.instance().function();
        Set<String> toSpace = factory.availableOperators();
        toSpace.remove("and");
        toSpace.remove("or");
        toSpace.add("(");
        toSpace.add(")");
        toSpace.add(",");
        String spacedFormula = formula;
        for (String operator : toSpace) {
            spacedFormula = spacedFormula.replace(operator, " " + operator + " ");
        }
        FuzzyLite.logger().fine(spacedFormula);
        ArrayDeque<String> queue = new ArrayDeque<String>();
        ArrayDeque<String> stack = new ArrayDeque<String>();
        StringTokenizer tokenizer = new StringTokenizer(spacedFormula);
        while (tokenizer.hasMoreTokens()) {
            boolean isOperand;
            String token = tokenizer.nextToken();
            Element element = (Element)factory.getObject(token);
            boolean bl = isOperand = element == null && !"(".equals(token) && !")".equals(token) && !",".equals(token);
            if (isOperand) {
                FuzzyLite.logger().fine(token + " is operand");
                queue.offer(token);
                continue;
            }
            if (element != null && element.isFunction()) {
                FuzzyLite.logger().fine(token + " is function");
                stack.push(token);
                continue;
            }
            if (",".equals(token)) {
                while (!stack.isEmpty() && !"(".equals(stack.peek())) {
                    queue.offer((String)stack.pop());
                }
                if (!stack.isEmpty() && "(".equals(stack.peek())) continue;
                throw new RuntimeException(String.format("[parsing error] mismatching parentheses in: %s", formula));
            }
            if (element != null && element.isOperator()) {
                FuzzyLite.logger().fine(token + " is operator");
                Element op1 = element;
                while (true) {
                    Element op2 = null;
                    if (!stack.isEmpty()) {
                        op2 = (Element)factory.getObject((String)stack.peek());
                    }
                    if (op2 == null || (op1.associativity >= 0 || op1.precedence != op2.precedence) && op1.precedence >= op2.precedence) break;
                    queue.offer((String)stack.pop());
                }
                stack.push(token);
                continue;
            }
            if ("(".equals(token)) {
                stack.push(token);
                continue;
            }
            if (")".equals(token)) {
                while (!stack.isEmpty() && !"(".equals(stack.peek())) {
                    queue.offer((String)stack.pop());
                }
                if (stack.isEmpty() || !"(".equals(stack.peek())) {
                    throw new RuntimeException(String.format("[parsing error] mismatching parentheses in: %s", formula));
                }
                stack.pop();
                Element top = null;
                if (!stack.isEmpty()) {
                    top = (Element)factory.getObject((String)stack.peek());
                }
                if (top == null || !top.isFunction()) continue;
                queue.offer((String)stack.pop());
                continue;
            }
            throw new RuntimeException(String.format("[parsing error] unexpected error with token <%s>", token));
        }
        while (!stack.isEmpty()) {
            if ("(".equals(stack.peek()) || ")".equals(stack.peek())) {
                throw new RuntimeException(String.format("[parsing error] mismatching parentheses in: %s", formula));
            }
            queue.offer((String)stack.pop());
        }
        StringBuilder result = new StringBuilder();
        while (!queue.isEmpty()) {
            result.append((String)queue.poll());
            if (queue.isEmpty()) continue;
            result.append(" ");
        }
        return result.toString();
    }

    public Node parse(String text) {
        if (text.isEmpty()) {
            return null;
        }
        String postfix = this.toPostfix(text);
        ArrayDeque<Node> stack = new ArrayDeque<Node>();
        StringTokenizer tokenizer = new StringTokenizer(postfix);
        FunctionFactory factory = FactoryManager.instance().function();
        while (tokenizer.hasMoreTokens()) {
            Node node;
            boolean isOperand;
            String token = tokenizer.nextToken();
            Element element = (Element)factory.getObject(token);
            boolean bl = isOperand = element == null && !"(".equals(token) && !")".equals(token) && !",".equals(token);
            if (element != null) {
                if (element.getArity() > stack.size()) {
                    throw new RuntimeException(String.format("[function error] operator <%s> has arity <%d>, but <%d> elements are available: (%s)", element.getName(), element.getArity(), stack.size(), Op.join(stack, ", ")));
                }
                try {
                    node = new Node(element.clone());
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                node.left = (Node)stack.pop();
                if (element.getArity() == 2) {
                    node.right = (Node)stack.pop();
                }
                stack.push(node);
                continue;
            }
            if (!isOperand) continue;
            try {
                double value = Op.toDouble(token);
                node = new Node(value);
            }
            catch (Exception ex) {
                node = new Node(token);
            }
            stack.push(node);
        }
        if (stack.size() != 1) {
            throw new RuntimeException(String.format("[function error] ill-formed formula <%s> due to: <%s>", text, Op.join(stack, ";")));
        }
        return (Node)stack.pop();
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public Node getRoot() {
        return this.root;
    }

    public Map<String, Double> getVariables() {
        return this.variables;
    }

    public static class Node
    implements Op.Cloneable {
        public Element element = null;
        public String variable = "";
        public double value = Double.NaN;
        public Node left = null;
        public Node right = null;

        public Node(Element element) {
            this.element = element;
        }

        public Node(String variable) {
            this.variable = variable;
        }

        public Node(double value) {
            this.value = value;
        }

        @Override
        public Node clone() throws CloneNotSupportedException {
            Node result = (Node)super.clone();
            if (this.element != null) {
                result.element = this.element.clone();
            }
            if (this.left != null) {
                result.left = this.left.clone();
            }
            if (this.right != null) {
                result.right = this.right.clone();
            }
            return result;
        }

        public double evaluate(Map<String, Double> localVariables) {
            Double result = Double.NaN;
            if (this.element != null) {
                try {
                    switch (this.element.getArity()) {
                        case 0: {
                            result = (Double)this.element.getMethod().invoke(null, new Object[0]);
                            break;
                        }
                        case 1: {
                            result = (Double)this.element.getMethod().invoke(null, this.left.evaluate(localVariables));
                            break;
                        }
                        case 2: {
                            result = (Double)this.element.getMethod().invoke(null, this.right.evaluate(localVariables), this.left.evaluate(localVariables));
                            break;
                        }
                        default: {
                            throw new RuntimeException(String.format("[function error] <%d>-ary element <%s> is not supported, only unary and binary elements are", this.element.getArity(), this.element.toString()));
                        }
                    }
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new RuntimeException("[function error] exception thrown invoking element <" + this.element.getName() + ">\n\t" + ex.toString(), ex);
                }
            } else if (this.variable != null && !this.variable.isEmpty()) {
                if (localVariables == null) {
                    throw new RuntimeException("[function error] expected a map of variables, but none was provided");
                }
                Double variableValue = localVariables.get(this.variable);
                if (variableValue == null) {
                    throw new RuntimeException("[function error] variable <" + this.variable + "> not registered in map");
                }
                result = variableValue;
            } else {
                result = this.value;
            }
            if (FuzzyLite.isDebugging()) {
                FuzzyLite.logger().fine(String.format("%s = %s", this.toPostfix(), Op.str(result)));
            }
            return result;
        }

        public String toString() {
            String result = this.element != null ? this.element.getName() : (this.variable != null && !this.variable.isEmpty() ? this.variable : Op.str(this.value));
            return result;
        }

        public String toPrefix() {
            return this.toPrefix(this);
        }

        public String toPrefix(Node node) {
            if (!Double.isNaN(node.value)) {
                return Op.str(node.value);
            }
            if (!node.variable.isEmpty()) {
                return node.variable;
            }
            String result = node.toString();
            if (node.left != null) {
                result = result + " " + this.toPrefix(node.left);
            }
            if (node.right != null) {
                result = result + " " + this.toPrefix(node.right);
            }
            return result;
        }

        public String toInfix() {
            return this.toInfix(this);
        }

        public String toInfix(Node node) {
            if (!Double.isNaN(node.value)) {
                return Op.str(node.value);
            }
            if (!node.variable.isEmpty()) {
                return node.variable;
            }
            String result = "";
            if (node.left != null) {
                result = result + this.toInfix(node.left) + " ";
            }
            result = result + node.toString();
            if (node.right != null) {
                result = result + " " + this.toInfix(node.right);
            }
            return result;
        }

        public String toPostfix() {
            return this.toPostfix(this);
        }

        public String toPostfix(Node node) {
            if (!Double.isNaN(node.value)) {
                return Op.str(node.value);
            }
            if (!node.variable.isEmpty()) {
                return node.variable;
            }
            String result = "";
            if (node.left != null) {
                result = result + this.toPostfix(node.left) + " ";
            }
            if (node.right != null) {
                result = result + this.toPrefix(node.right) + " ";
            }
            result = result + node.toString();
            return result;
        }
    }

    public static class Element
    implements Op.Cloneable {
        private String name;
        private String description;
        private Type type;
        private Method method;
        private int precedence;
        private int associativity;

        public Element(String name, String description, Type type) {
            this(name, description, type, null);
        }

        public Element(String name, String description, Type type, Method method) {
            this(name, description, type, method, 0);
        }

        public Element(String name, String description, Type type, Method method, int precedence) {
            this(name, description, type, method, precedence, -1);
        }

        public Element(String name, String description, Type type, Method method, int precedence, int associativity) {
            this.name = name;
            this.description = description;
            this.type = type;
            this.method = method;
            this.precedence = precedence;
            this.associativity = associativity;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Method getMethod() {
            return this.method;
        }

        public void setMethod(Method method) {
            this.method = method;
        }

        public int getArity() {
            return this.method.getParameterTypes().length;
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public boolean isOperator() {
            return this.type == Type.Operator;
        }

        public boolean isFunction() {
            return this.type == Type.Function;
        }

        public int getPrecedence() {
            return this.precedence;
        }

        public void setPrecedence(int precedence) {
            this.precedence = precedence;
        }

        public int getAssociativity() {
            return this.associativity;
        }

        public void setAssociativity(int associativity) {
            this.associativity = associativity;
        }

        @Override
        public Element clone() throws CloneNotSupportedException {
            return (Element)super.clone();
        }

        public static enum Type {
            Operator,
            Function;

        }
    }
}

