/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.term;

import com.fuzzylite.Op;
import com.fuzzylite.term.Term;
import java.util.Iterator;
import java.util.List;

public class Gaussian
extends Term {
    private double mean;
    private double standardDeviation;

    public Gaussian() {
        this("");
    }

    public Gaussian(String name) {
        this(name, Double.NaN, Double.NaN);
    }

    public Gaussian(String name, double mean, double standardDeviation) {
        this(name, mean, standardDeviation, 1.0);
    }

    public Gaussian(String name, double mean, double standardDeviation, double height) {
        super(name, height);
        this.mean = mean;
        this.standardDeviation = standardDeviation;
    }

    @Override
    public String parameters() {
        return Op.join(" ", this.mean, this.standardDeviation) + (!Op.isEq(this.height, 1.0) ? " " + Op.str(this.height) : "");
    }

    @Override
    public void configure(String parameters) {
        if (parameters.isEmpty()) {
            return;
        }
        List<String> values = Op.split(parameters, " ");
        int required = 2;
        if (values.size() < required) {
            throw new RuntimeException(String.format("[configuration error] term <%s> requires <%d> parameters", this.getClass().getSimpleName(), required));
        }
        Iterator<String> it = values.iterator();
        this.setMean(Op.toDouble(it.next()));
        this.setStandardDeviation(Op.toDouble(it.next()));
        if (values.size() > required) {
            this.setHeight(Op.toDouble(it.next()));
        }
    }

    @Override
    public double membership(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        return this.height * Math.exp(-(x - this.mean) * (x - this.mean) / (2.0 * this.standardDeviation * this.standardDeviation));
    }

    public double getMean() {
        return this.mean;
    }

    public void setMean(double mean) {
        this.mean = mean;
    }

    public double getStandardDeviation() {
        return this.standardDeviation;
    }

    public void setStandardDeviation(double standardDeviation) {
        this.standardDeviation = standardDeviation;
    }

    @Override
    public Gaussian clone() throws CloneNotSupportedException {
        return (Gaussian)super.clone();
    }
}

