/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.term;

import com.fuzzylite.Op;
import com.fuzzylite.term.Term;
import java.util.Iterator;
import java.util.List;

public class GaussianProduct
extends Term {
    private double meanA;
    private double standardDeviationA;
    private double meanB;
    private double standardDeviationB;

    public GaussianProduct() {
        this("");
    }

    public GaussianProduct(String name) {
        this(name, Double.NaN, Double.NaN, Double.NaN, Double.NaN);
    }

    public GaussianProduct(String name, double meanA, double standardDeviationA, double meanB, double standardDeviationB) {
        this(name, meanA, standardDeviationA, meanB, standardDeviationB, 1.0);
    }

    public GaussianProduct(String name, double meanA, double standardDeviationA, double meanB, double standardDeviationB, double height) {
        super(name, height);
        this.meanA = meanA;
        this.standardDeviationA = standardDeviationA;
        this.meanB = meanB;
        this.standardDeviationB = standardDeviationB;
    }

    @Override
    public String parameters() {
        return Op.join(" ", this.meanA, this.standardDeviationA, this.meanB, this.standardDeviationB) + (!Op.isEq(this.height, 1.0) ? " " + Op.str(this.height) : "");
    }

    @Override
    public void configure(String parameters) {
        if (parameters.isEmpty()) {
            return;
        }
        List<String> values = Op.split(parameters, " ");
        int required = 4;
        if (values.size() < required) {
            throw new RuntimeException(String.format("[configuration error] term <%s> requires <%d> parameters", this.getClass().getSimpleName(), required));
        }
        Iterator<String> it = values.iterator();
        this.setMeanA(Op.toDouble(it.next()));
        this.setStandardDeviationA(Op.toDouble(it.next()));
        this.setMeanB(Op.toDouble(it.next()));
        this.setStandardDeviationB(Op.toDouble(it.next()));
        if (values.size() > required) {
            this.setHeight(Op.toDouble(it.next()));
        }
    }

    @Override
    public double membership(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        double a = 1.0;
        double b = 1.0;
        if (Op.isLt(x, this.meanA)) {
            a = Math.exp(-(x - this.meanA) * (x - this.meanA) / (2.0 * this.standardDeviationA * this.standardDeviationA));
        }
        if (Op.isGt(x, this.meanB)) {
            b = Math.exp(-(x - this.meanB) * (x - this.meanB) / (2.0 * this.standardDeviationB * this.standardDeviationB));
        }
        return this.height * a * b;
    }

    public double getMeanA() {
        return this.meanA;
    }

    public void setMeanA(double meanA) {
        this.meanA = meanA;
    }

    public double getStandardDeviationA() {
        return this.standardDeviationA;
    }

    public void setStandardDeviationA(double standardDeviationA) {
        this.standardDeviationA = standardDeviationA;
    }

    public double getMeanB() {
        return this.meanB;
    }

    public void setMeanB(double meanB) {
        this.meanB = meanB;
    }

    public double getStandardDeviationB() {
        return this.standardDeviationB;
    }

    public void setStandardDeviationB(double standardDeviationB) {
        this.standardDeviationB = standardDeviationB;
    }

    @Override
    public GaussianProduct clone() throws CloneNotSupportedException {
        return (GaussianProduct)super.clone();
    }
}

