/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.term;

import com.fuzzylite.Engine;
import com.fuzzylite.Op;
import com.fuzzylite.term.Term;
import com.fuzzylite.variable.InputVariable;
import java.util.ArrayList;
import java.util.List;

public class Linear
extends Term {
    private List<Double> coefficients;
    private Engine engine;

    public Linear() {
        this("");
    }

    public Linear(String name) {
        this(name, new ArrayList<Double>(), null);
    }

    public Linear(String name, List<Double> coefficients) {
        this(name, coefficients, null);
    }

    public Linear(String name, List<Double> coefficients, Engine engine) {
        super(name);
        this.coefficients = coefficients;
        this.engine = engine;
    }

    @Override
    public String parameters() {
        return Op.join(this.coefficients, " ");
    }

    @Override
    public void configure(String parameters) {
        this.coefficients.clear();
        if (parameters.isEmpty()) {
            return;
        }
        List<String> values = Op.split(parameters, " ");
        for (String x : values) {
            this.coefficients.add(Op.toDouble(x));
        }
    }

    public static Linear create(String name, Engine engine, double ... coefficients) {
        ArrayList<Double> coefficientsList = new ArrayList<Double>(coefficients.length);
        for (double coefficient : coefficients) {
            coefficientsList.add(coefficient);
        }
        return new Linear(name, coefficientsList, engine);
    }

    @Override
    public double membership(double x) {
        double result = 0.0;
        List<InputVariable> inputVariables = this.engine.getInputVariables();
        int numberOfVariables = inputVariables.size();
        int numberOfCoefficients = this.coefficients.size();
        for (int i = 0; i < numberOfVariables; ++i) {
            if (i >= numberOfCoefficients) continue;
            result += this.coefficients.get(i) * inputVariables.get(i).getValue();
        }
        if (numberOfCoefficients > numberOfVariables) {
            result += this.coefficients.get(numberOfCoefficients - 1).doubleValue();
        }
        return result;
    }

    public List<Double> getCoefficients() {
        return this.coefficients;
    }

    public void setCoefficients(List<Double> coefficients) {
        this.coefficients = coefficients;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public void set(List<Double> coefficients, Engine engine) {
        this.setCoefficients(coefficients);
        this.setEngine(engine);
    }

    @Override
    public Linear clone() throws CloneNotSupportedException {
        Linear result = (Linear)super.clone();
        result.coefficients = new ArrayList<Double>(this.coefficients);
        return result;
    }

    @Override
    public void updateReference(Engine engine) {
        this.setEngine(engine);
    }
}

