/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.term;

import com.fuzzylite.Op;
import com.fuzzylite.term.Term;
import java.util.Iterator;
import java.util.List;

public class PiShape
extends Term {
    private double bottomLeft;
    private double topLeft;
    private double topRight;
    private double bottomRight;

    public PiShape() {
        this("");
    }

    public PiShape(String name) {
        this(name, Double.NaN, Double.NaN, Double.NaN, Double.NaN);
    }

    public PiShape(String name, double bottomLeft, double topLeft, double topRight, double bottomRight) {
        this(name, bottomLeft, topLeft, topRight, bottomRight, 1.0);
    }

    public PiShape(String name, double bottomLeft, double topLeft, double topRight, double bottomRight, double height) {
        super(name, height);
        this.bottomLeft = bottomLeft;
        this.topLeft = topLeft;
        this.topRight = topRight;
        this.bottomRight = bottomRight;
    }

    @Override
    public String parameters() {
        return Op.join(" ", this.bottomLeft, this.topLeft, this.topRight, this.bottomRight) + (!Op.isEq(this.height, 1.0) ? " " + Op.str(this.height) : "");
    }

    @Override
    public void configure(String parameters) {
        if (parameters.isEmpty()) {
            return;
        }
        List<String> values = Op.split(parameters, " ");
        int required = 4;
        if (values.size() < required) {
            throw new RuntimeException(String.format("[configuration error] term <%s> requires <%d> parameters", this.getClass().getSimpleName(), required));
        }
        Iterator<String> it = values.iterator();
        this.setBottomLeft(Op.toDouble(it.next()));
        this.setTopLeft(Op.toDouble(it.next()));
        this.setTopRight(Op.toDouble(it.next()));
        this.setBottomRight(Op.toDouble(it.next()));
        if (values.size() > required) {
            this.setHeight(Op.toDouble(it.next()));
        }
    }

    @Override
    public double membership(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        double sshape = Op.isLE(x, this.bottomLeft) ? 0.0 : (Op.isLE(x, 0.5 * (this.bottomLeft + this.topLeft)) ? 2.0 * Math.pow((x - this.bottomLeft) / (this.topLeft - this.bottomLeft), 2.0) : (Op.isLt(x, this.topLeft) ? 1.0 - 2.0 * Math.pow((x - this.topLeft) / (this.topLeft - this.bottomLeft), 2.0) : 1.0));
        double zshape = Op.isLE(x, this.topRight) ? 1.0 : (Op.isLE(x, 0.5 * (this.topRight + this.bottomRight)) ? 1.0 - 2.0 * Math.pow((x - this.topRight) / (this.bottomRight - this.topRight), 2.0) : (Op.isLt(x, this.bottomRight) ? 2.0 * Math.pow((x - this.bottomRight) / (this.bottomRight - this.topRight), 2.0) : 0.0));
        return this.height * sshape * zshape;
    }

    public double getBottomLeft() {
        return this.bottomLeft;
    }

    public void setBottomLeft(double bottomLeft) {
        this.bottomLeft = bottomLeft;
    }

    public double getTopLeft() {
        return this.topLeft;
    }

    public void setTopLeft(double topLeft) {
        this.topLeft = topLeft;
    }

    public double getTopRight() {
        return this.topRight;
    }

    public void setTopRight(double topRight) {
        this.topRight = topRight;
    }

    public double getBottomRight() {
        return this.bottomRight;
    }

    public void setBottomRight(double bottomRight) {
        this.bottomRight = bottomRight;
    }

    @Override
    public PiShape clone() throws CloneNotSupportedException {
        return (PiShape)super.clone();
    }
}

