/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.term;

import com.fuzzylite.Op;
import com.fuzzylite.term.Term;
import java.util.Iterator;
import java.util.List;

public class Ramp
extends Term {
    private double start;
    private double end;

    public Ramp() {
        this("");
    }

    public Ramp(String name) {
        this(name, Double.NaN, Double.NaN);
    }

    public Ramp(String name, double start, double end) {
        this(name, start, end, 1.0);
    }

    public Ramp(String name, double start, double end, double height) {
        super(name, height);
        this.start = start;
        this.end = end;
    }

    @Override
    public String parameters() {
        return Op.join(" ", this.start, this.end) + (!Op.isEq(this.height, 1.0) ? " " + Op.str(this.height) : "");
    }

    @Override
    public void configure(String parameters) {
        if (parameters.isEmpty()) {
            return;
        }
        List<String> values = Op.split(parameters, " ");
        int required = 2;
        if (values.size() < required) {
            throw new RuntimeException(String.format("[configuration error] term <%s> requires <%d> parameters", this.getClass().getSimpleName(), required));
        }
        Iterator<String> it = values.iterator();
        this.setStart(Op.toDouble(it.next()));
        this.setEnd(Op.toDouble(it.next()));
        if (values.size() > required) {
            this.setHeight(Op.toDouble(it.next()));
        }
    }

    @Override
    public double membership(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (Op.isEq(this.start, this.end)) {
            return this.height * 0.0;
        }
        if (Op.isLt(this.start, this.end)) {
            if (Op.isLE(x, this.start)) {
                return this.height * 0.0;
            }
            if (Op.isGE(x, this.end)) {
                return this.height * 1.0;
            }
            return this.height * (x - this.start) / (this.end - this.start);
        }
        if (Op.isGE(x, this.start)) {
            return this.height * 0.0;
        }
        if (Op.isLE(x, this.end)) {
            return this.height * 1.0;
        }
        return this.height * (this.start - x) / (this.start - this.end);
    }

    @Override
    public double tsukamoto(double activationDegree, double minimum, double maximum) {
        return Op.scale(activationDegree, 0.0, 1.0, this.start, this.end);
    }

    @Override
    public boolean isMonotonic() {
        return true;
    }

    public double getStart() {
        return this.start;
    }

    public void setStart(double start) {
        this.start = start;
    }

    public double getEnd() {
        return this.end;
    }

    public void setEnd(double end) {
        this.end = end;
    }

    public Direction direction() {
        double range = this.end - this.start;
        if (!Op.isFinite(range) || Op.isEq(range, 0.0)) {
            return Direction.Zero;
        }
        if (Op.isGt(range, 0.0)) {
            return Direction.Positive;
        }
        return Direction.Negative;
    }

    @Override
    public Ramp clone() throws CloneNotSupportedException {
        return (Ramp)super.clone();
    }

    public static enum Direction {
        Positive,
        Zero,
        Negative;

    }
}

