/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.term;

import com.fuzzylite.Op;
import com.fuzzylite.term.Term;
import java.util.Iterator;
import java.util.List;

public class Rectangle
extends Term {
    private double start;
    private double end;

    public Rectangle() {
        this("");
    }

    public Rectangle(String name) {
        this(name, Double.NaN, Double.NaN);
    }

    public Rectangle(String name, double start, double end) {
        this(name, start, end, 1.0);
    }

    public Rectangle(String name, double start, double end, double height) {
        super(name, height);
        this.start = start;
        this.end = end;
    }

    @Override
    public String parameters() {
        return Op.join(" ", this.start, this.end) + (!Op.isEq(this.height, 1.0) ? " " + Op.str(this.height) : "");
    }

    @Override
    public void configure(String parameters) {
        if (parameters.isEmpty()) {
            return;
        }
        List<String> values = Op.split(parameters, " ");
        int required = 2;
        if (values.size() < required) {
            throw new RuntimeException(String.format("[configuration error] term <%s> requires <%d> parameters", this.getClass().getSimpleName(), required));
        }
        Iterator<String> it = values.iterator();
        this.setStart(Op.toDouble(it.next()));
        this.setEnd(Op.toDouble(it.next()));
        if (values.size() > required) {
            this.setHeight(Op.toDouble(it.next()));
        }
    }

    @Override
    public double membership(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (Op.isGE(x, this.start) && Op.isLE(x, this.end)) {
            return this.height * 1.0;
        }
        return this.height * 0.0;
    }

    public double getStart() {
        return this.start;
    }

    public void setStart(double start) {
        this.start = start;
    }

    public double getEnd() {
        return this.end;
    }

    public void setEnd(double end) {
        this.end = end;
    }

    @Override
    public Rectangle clone() throws CloneNotSupportedException {
        return (Rectangle)super.clone();
    }
}

