/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.term;

import com.fuzzylite.Op;
import com.fuzzylite.term.Term;
import java.util.Iterator;
import java.util.List;

public class Sigmoid
extends Term {
    private double inflection;
    private double slope;

    public Sigmoid() {
        this("");
    }

    public Sigmoid(String name) {
        this(name, Double.NaN, Double.NaN);
    }

    public Sigmoid(String name, double inflection, double slope) {
        this(name, inflection, slope, 1.0);
    }

    public Sigmoid(String name, double inflection, double slope, double height) {
        super(name, height);
        this.inflection = inflection;
        this.slope = slope;
    }

    @Override
    public String parameters() {
        return Op.join(" ", this.inflection, this.slope) + (!Op.isEq(this.height, 1.0) ? " " + Op.str(this.height) : "");
    }

    @Override
    public void configure(String parameters) {
        if (parameters.isEmpty()) {
            return;
        }
        List<String> values = Op.split(parameters, " ");
        int required = 2;
        if (values.size() < required) {
            throw new RuntimeException(String.format("[configuration error] term <%s> requires <%d> parameters", this.getClass().getSimpleName(), required));
        }
        Iterator<String> it = values.iterator();
        this.setInflection(Op.toDouble(it.next()));
        this.setSlope(Op.toDouble(it.next()));
        if (values.size() > required) {
            this.setHeight(Op.toDouble(it.next()));
        }
    }

    @Override
    public double membership(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        return this.height * 1.0 / (1.0 + Math.exp(-this.slope * (x - this.inflection)));
    }

    @Override
    public double tsukamoto(double activationDegree, double minimum, double maximum) {
        double z;
        double w = activationDegree;
        if (Op.isEq(w, 1.0)) {
            z = Op.isGE(this.slope, 0.0) ? maximum : minimum;
        } else if (Op.isEq(w, 0.0)) {
            z = Op.isGE(this.slope, 0.0) ? minimum : maximum;
        } else {
            double a = this.slope;
            double b = this.inflection;
            z = b + Math.log(1.0 / w - 1.0) / -a;
        }
        return z;
    }

    @Override
    public boolean isMonotonic() {
        return true;
    }

    public double getInflection() {
        return this.inflection;
    }

    public void setInflection(double inflection) {
        this.inflection = inflection;
    }

    public double getSlope() {
        return this.slope;
    }

    public void setSlope(double slope) {
        this.slope = slope;
    }

    public Direction direction() {
        if (!Op.isFinite(this.slope) || Op.isEq(this.slope, 0.0)) {
            return Direction.Zero;
        }
        if (Op.isGt(this.slope, 0.0)) {
            return Direction.Positive;
        }
        return Direction.Negative;
    }

    @Override
    public Sigmoid clone() throws CloneNotSupportedException {
        return (Sigmoid)super.clone();
    }

    public static enum Direction {
        Positive,
        Zero,
        Negative;

    }
}

