/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.term;

import com.fuzzylite.Op;
import com.fuzzylite.term.Term;
import java.util.Iterator;
import java.util.List;

public class SigmoidProduct
extends Term {
    private double left;
    private double rising;
    private double falling;
    private double right;

    public SigmoidProduct() {
        this("");
    }

    public SigmoidProduct(String name) {
        this(name, Double.NaN, Double.NaN, Double.NaN, Double.NaN);
    }

    public SigmoidProduct(String name, double left, double rising, double falling, double right) {
        this(name, left, rising, falling, right, 1.0);
    }

    public SigmoidProduct(String name, double left, double rising, double falling, double right, double height) {
        super(name, height);
        this.left = left;
        this.rising = rising;
        this.falling = falling;
        this.right = right;
    }

    @Override
    public String parameters() {
        return Op.join(" ", this.left, this.rising, this.falling, this.right) + (!Op.isEq(this.height, 1.0) ? " " + Op.str(this.height) : "");
    }

    @Override
    public void configure(String parameters) {
        if (parameters.isEmpty()) {
            return;
        }
        List<String> values = Op.split(parameters, " ");
        int required = 4;
        if (values.size() < required) {
            throw new RuntimeException(String.format("[configuration error] term <%s> requires <%d> parameters", this.getClass().getSimpleName(), required));
        }
        Iterator<String> it = values.iterator();
        this.setLeft(Op.toDouble(it.next()));
        this.setRising(Op.toDouble(it.next()));
        this.setFalling(Op.toDouble(it.next()));
        this.setRight(Op.toDouble(it.next()));
        if (values.size() > required) {
            this.setHeight(Op.toDouble(it.next()));
        }
    }

    @Override
    public double membership(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        double a = 1.0 + Math.exp(-this.rising * (x - this.left));
        double b = 1.0 + Math.exp(-this.falling * (x - this.right));
        return this.height * 1.0 / (a * b);
    }

    public double getLeft() {
        return this.left;
    }

    public void setLeft(double leftInflection) {
        this.left = leftInflection;
    }

    public double getRising() {
        return this.rising;
    }

    public void setRising(double risingSlope) {
        this.rising = risingSlope;
    }

    public double getFalling() {
        return this.falling;
    }

    public void setFalling(double fallingSlope) {
        this.falling = fallingSlope;
    }

    public double getRight() {
        return this.right;
    }

    public void setRight(double rightInflection) {
        this.right = rightInflection;
    }

    @Override
    public SigmoidProduct clone() throws CloneNotSupportedException {
        return (SigmoidProduct)super.clone();
    }
}

