/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.term;

import com.fuzzylite.Op;
import com.fuzzylite.term.Term;
import java.util.Iterator;
import java.util.List;

public class Spike
extends Term {
    private double center;
    private double width;

    public Spike() {
        this("");
    }

    public Spike(String name) {
        this(name, Double.NaN, Double.NaN);
    }

    public Spike(String name, double center, double width) {
        this(name, center, width, 1.0);
    }

    public Spike(String name, double center, double width, double height) {
        super(name, height);
        this.center = center;
        this.width = width;
    }

    @Override
    public String parameters() {
        return Op.join(" ", this.center, this.width) + (!Op.isEq(this.height, 1.0) ? " " + Op.str(this.height) : "");
    }

    @Override
    public void configure(String parameters) {
        if (parameters.isEmpty()) {
            return;
        }
        List<String> values = Op.split(parameters, " ");
        int required = 2;
        if (values.size() < required) {
            throw new RuntimeException(String.format("[configuration error] term <%s> requires <%d> parameters", this.getClass().getSimpleName(), required));
        }
        Iterator<String> it = values.iterator();
        this.setCenter(Op.toDouble(it.next()));
        this.setWidth(Op.toDouble(it.next()));
        if (values.size() > required) {
            this.setHeight(Op.toDouble(it.next()));
        }
    }

    @Override
    public double membership(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        return this.height * Math.exp(-Math.abs(10.0 / this.width * (x - this.center)));
    }

    public double getCenter() {
        return this.center;
    }

    public void setCenter(double center) {
        this.center = center;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    @Override
    public Spike clone() throws CloneNotSupportedException {
        return (Spike)super.clone();
    }
}

