/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.term;

import com.fuzzylite.Op;
import com.fuzzylite.term.Term;
import java.util.Iterator;
import java.util.List;

public class Trapezoid
extends Term {
    private double vertexA;
    private double vertexB;
    private double vertexC;
    private double vertexD;

    public Trapezoid() {
        this("");
    }

    public Trapezoid(String name) {
        this(name, Double.NaN, Double.NaN);
    }

    public Trapezoid(String name, double vertexA, double vertexD) {
        this(name, vertexA, vertexA + (vertexD - vertexA) * 1.0 / 5.0, vertexA + (vertexD - vertexA) * 4.0 / 5.0, vertexD);
    }

    public Trapezoid(String name, double vertexA, double vertexB, double vertexC, double vertexD) {
        this(name, vertexA, vertexB, vertexC, vertexD, 1.0);
    }

    public Trapezoid(String name, double vertexA, double vertexB, double vertexC, double vertexD, double height) {
        super(name, height);
        this.vertexA = vertexA;
        this.vertexB = vertexB;
        this.vertexC = vertexC;
        this.vertexD = vertexD;
    }

    @Override
    public String parameters() {
        return Op.join(" ", this.vertexA, this.vertexB, this.vertexC, this.vertexD) + (!Op.isEq(this.height, 1.0) ? " " + Op.str(this.height) : "");
    }

    @Override
    public void configure(String parameters) {
        if (parameters.isEmpty()) {
            return;
        }
        List<String> values = Op.split(parameters, " ");
        int required = 4;
        if (values.size() < required) {
            throw new RuntimeException(String.format("[configuration error] term <%s> requires <%d> parameters", this.getClass().getSimpleName(), required));
        }
        Iterator<String> it = values.iterator();
        this.setVertexA(Op.toDouble(it.next()));
        this.setVertexB(Op.toDouble(it.next()));
        this.setVertexC(Op.toDouble(it.next()));
        this.setVertexD(Op.toDouble(it.next()));
        if (values.size() > required) {
            this.setHeight(Op.toDouble(it.next()));
        }
    }

    @Override
    public double membership(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (Op.isLt(x, this.vertexA) || Op.isGt(x, this.vertexD)) {
            return this.height * 0.0;
        }
        if (Op.isLt(x, this.vertexB)) {
            return this.height * Math.min(1.0, (x - this.vertexA) / (this.vertexB - this.vertexA));
        }
        if (Op.isLE(x, this.vertexC)) {
            return this.height * 1.0;
        }
        if (Op.isLt(x, this.vertexD)) {
            return this.height * (this.vertexD - x) / (this.vertexD - this.vertexC);
        }
        return this.height * 0.0;
    }

    public double getVertexA() {
        return this.vertexA;
    }

    public void setVertexA(double a) {
        this.vertexA = a;
    }

    public double getVertexB() {
        return this.vertexB;
    }

    public void setVertexB(double b) {
        this.vertexB = b;
    }

    public double getVertexC() {
        return this.vertexC;
    }

    public void setVertexC(double c) {
        this.vertexC = c;
    }

    public double getVertexD() {
        return this.vertexD;
    }

    public void setVertexD(double d) {
        this.vertexD = d;
    }

    @Override
    public Trapezoid clone() throws CloneNotSupportedException {
        return (Trapezoid)super.clone();
    }
}

