/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.term;

import com.fuzzylite.Op;
import com.fuzzylite.term.Term;
import java.util.Iterator;
import java.util.List;

public class Triangle
extends Term {
    private double vertexA;
    private double vertexB;
    private double vertexC;

    public Triangle() {
        this("");
    }

    public Triangle(String name) {
        this(name, Double.NaN, Double.NaN, Double.NaN);
    }

    public Triangle(String name, double vertexA, double vertexC) {
        this(name, vertexA, (vertexA + vertexC) / 2.0, vertexC);
    }

    public Triangle(String name, double vertexA, double vertexB, double vertexC) {
        this(name, vertexA, vertexB, vertexC, 1.0);
    }

    public Triangle(String name, double vertexA, double vertexB, double vertexC, double height) {
        super(name, height);
        this.vertexA = vertexA;
        this.vertexB = vertexB;
        this.vertexC = vertexC;
    }

    @Override
    public String parameters() {
        return Op.join(" ", this.vertexA, this.vertexB, this.vertexC) + (!Op.isEq(this.height, 1.0) ? " " + Op.str(this.height) : "");
    }

    @Override
    public void configure(String parameters) {
        if (parameters.isEmpty()) {
            return;
        }
        List<String> values = Op.split(parameters, " ");
        int required = 3;
        if (values.size() < required) {
            throw new RuntimeException(String.format("[configuration error] term <%s> requires <%d> parameters", this.getClass().getSimpleName(), required));
        }
        Iterator<String> it = values.iterator();
        this.setVertexA(Op.toDouble(it.next()));
        this.setVertexB(Op.toDouble(it.next()));
        this.setVertexC(Op.toDouble(it.next()));
        if (values.size() > required) {
            this.setHeight(Op.toDouble(it.next()));
        }
    }

    @Override
    public double membership(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (Op.isLt(x, this.vertexA) || Op.isGt(x, this.vertexC)) {
            return this.height * 0.0;
        }
        if (Op.isEq(x, this.vertexB)) {
            return this.height * 1.0;
        }
        if (Op.isLt(x, this.vertexB)) {
            return this.height * (x - this.vertexA) / (this.vertexB - this.vertexA);
        }
        return this.height * (this.vertexC - x) / (this.vertexC - this.vertexB);
    }

    public double getVertexA() {
        return this.vertexA;
    }

    public void setVertexA(double a) {
        this.vertexA = a;
    }

    public double getVertexB() {
        return this.vertexB;
    }

    public void setVertexB(double b) {
        this.vertexB = b;
    }

    public double getVertexC() {
        return this.vertexC;
    }

    public void setVertexC(double c) {
        this.vertexC = c;
    }

    @Override
    public Triangle clone() throws CloneNotSupportedException {
        return (Triangle)super.clone();
    }
}

